/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.core.render;

import com.tttsaurus.ingameinfo.common.core.function.IAction;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.lwjgl.opengl.GL11;

public final class RenderMask {
    private static final Stack<RenderMask> maskStack = new Stack();
    private static int stencilValueCounter = 0;
    public MaskShape maskShape;
    private final Map<MaskShape, Boolean> init = new HashMap<MaskShape, Boolean>();
    private final int stencilValue;
    private float x;
    private float y;
    private float width;
    private float height;
    private float radius;
    private IAction drawMask;

    private static int nextStencilValue() {
        if (++stencilValueCounter > 254) {
            stencilValueCounter = 1;
            GL11.glClearStencil((int)0);
            GL11.glClear((int)1024);
        }
        return stencilValueCounter;
    }

    public static void resetStencilCounter() {
        stencilValueCounter = 0;
    }

    public RenderMask(MaskShape maskShape) {
        this.maskShape = maskShape;
        this.init.put(MaskShape.RECT, false);
        this.init.put(MaskShape.ROUNDED_RECT, false);
        this.init.put(MaskShape.CUSTOM, false);
        this.stencilValue = RenderMask.nextStencilValue();
    }

    public void setRectMask(float x, float y, float width, float height) {
        this.init.put(MaskShape.RECT, true);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setRoundedRectMask(float x, float y, float width, float height, float radius) {
        this.init.put(MaskShape.ROUNDED_RECT, true);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.radius = radius;
    }

    public void setCustomMask(IAction drawMask) {
        this.init.put(MaskShape.CUSTOM, true);
        this.drawMask = drawMask;
    }

    private static void drawStencilArea(RenderMask mask) {
        switch (mask.maskShape) {
            case RECT: {
                if (!mask.init.get((Object)MaskShape.RECT).booleanValue()) break;
                RenderUtils.drawRectStencilArea(mask.x, mask.y, mask.width, mask.height);
                break;
            }
            case ROUNDED_RECT: {
                if (!mask.init.get((Object)MaskShape.ROUNDED_RECT).booleanValue()) break;
                RenderUtils.drawRoundedRectStencilArea(mask.x, mask.y, mask.width, mask.height, mask.radius);
                break;
            }
            case CUSTOM: {
                if (!mask.init.get((Object)MaskShape.CUSTOM).booleanValue() || mask.drawMask == null) break;
                mask.drawMask.invoke();
            }
        }
    }

    public void startMasking() {
        if (maskStack.isEmpty()) {
            maskStack.push(this);
        } else if (maskStack.peek() != this) {
            maskStack.push(this);
        }
        RenderUtils.prepareStencilToWrite(this.stencilValue);
        RenderMask.drawStencilArea(this);
        if (maskStack.size() > 1) {
            ListIterator iterator = maskStack.listIterator(maskStack.size());
            iterator.previous();
            while (iterator.hasPrevious()) {
                RenderMask prevMask = (RenderMask)iterator.previous();
                RenderUtils.prepareStencilToIncrease(this.stencilValue);
                RenderMask.drawStencilArea(prevMask);
                RenderUtils.prepareStencilToZero(this.stencilValue);
                RenderMask.drawStencilArea(this);
                RenderUtils.prepareStencilToDecrease(this.stencilValue + 1);
                RenderMask.drawStencilArea(this);
            }
        }
        RenderUtils.prepareStencilToRender(this.stencilValue);
    }

    public static void endMasking() {
        RenderUtils.endStencil();
        maskStack.pop();
        if (!maskStack.isEmpty()) {
            maskStack.peek().startMasking();
        }
    }

    public static enum MaskShape {
        RECT,
        ROUNDED_RECT,
        CUSTOM;

    }
}

