/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.control;

import com.tttsaurus.ingameinfo.common.core.gui.control.Interactable;
import com.tttsaurus.ingameinfo.common.core.gui.event.IUIEventListener;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEvent;
import com.tttsaurus.ingameinfo.common.core.gui.event.UIEventListenerType;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.CallbackInfo;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StylePropertyCallback;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;
import com.tttsaurus.ingameinfo.common.impl.gui.render.op.ButtonOp;

@RegisterElement
public class Button
extends Interactable {
    private int currentColor;
    @StyleProperty
    public int defaultColor;
    @StyleProperty
    public int hoverColor;
    @StyleProperty
    public int holdColor;
    private int currentTextColor;
    @StyleProperty
    public int defaultTextColor;
    @StyleProperty
    public int hoverTextColor;
    @StyleProperty
    public int holdTextColor;
    @StyleProperty(setterCallbackPost="setTextCallback", setterCallbackPre="textValidation")
    public String text;
    @StyleProperty
    public boolean shadow = true;

    @StylePropertyCallback
    public void textValidation(String value, CallbackInfo callbackInfo) {
        if (value == null) {
            callbackInfo.cancel = true;
        }
    }

    @StylePropertyCallback
    public void setTextCallback() {
        this.width = RenderUtils.simulateTextWidth(this.text, 1.0f) + 10.0f;
        this.height = RenderUtils.simulateTextHeight(1.0f) + 10.0f;
        this.requestReCalc();
    }

    public Button() {
        this.addEventListener(UIEvent.MouseEnter.class, new IUIEventListener<UIEvent.MouseEnter>(){

            @Override
            public void handle(UIEvent.MouseEnter event) {
                Button.this.currentColor = Button.this.hoverColor;
                Button.this.currentTextColor = Button.this.hoverTextColor;
            }

            @Override
            public UIEventListenerType type() {
                return UIEventListenerType.LOCAL;
            }
        });
        this.addEventListener(UIEvent.MousePress.class, new IUIEventListener<UIEvent.MousePress>(){

            @Override
            public void handle(UIEvent.MousePress event) {
                Button.this.currentColor = Button.this.holdColor;
                Button.this.currentTextColor = Button.this.holdTextColor;
            }

            @Override
            public UIEventListenerType type() {
                return UIEventListenerType.LOCAL;
            }
        });
        this.addEventListener(UIEvent.MouseLeave.class, new IUIEventListener<UIEvent.MouseLeave>(){

            @Override
            public void handle(UIEvent.MouseLeave event) {
                Button.this.currentColor = Button.this.defaultColor;
                Button.this.currentTextColor = Button.this.defaultTextColor;
            }

            @Override
            public UIEventListenerType type() {
                return UIEventListenerType.LOCAL;
            }
        });
        this.addEventListener(UIEvent.MouseRelease.class, new IUIEventListener<UIEvent.MouseRelease>(){

            @Override
            public void handle(UIEvent.MouseRelease event) {
                Button.this.currentColor = Button.this.defaultColor;
                Button.this.currentTextColor = Button.this.defaultTextColor;
            }

            @Override
            public UIEventListenerType type() {
                return UIEventListenerType.LOCAL;
            }
        });
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        queue.enqueue(new ButtonOp(this.rect, this.currentColor, this.text, this.rect.x + (this.rect.width - RenderUtils.simulateTextWidth(this.text, 1.0f)) / 2.0f, this.rect.y + (this.rect.height - RenderUtils.simulateTextHeight(1.0f)) / 2.0f, 1.0f, this.currentTextColor, this.shadow, this.hover, this.hold));
    }

    @Override
    public void applyLogicTheme(ThemeConfig themeConfig) {
        super.applyLogicTheme(themeConfig);
        if (this.defaultColor == 0) {
            this.setStyleProperty("defaultColor", themeConfig.button.parsedDefaultColor);
        }
        if (this.hoverColor == 0) {
            this.setStyleProperty("hoverColor", themeConfig.button.parsedHoverColor);
        }
        if (this.holdColor == 0) {
            this.setStyleProperty("holdColor", themeConfig.button.parsedHoldColor);
        }
        if (this.defaultTextColor == 0) {
            this.setStyleProperty("defaultTextColor", themeConfig.button.parsedDefaultTextColor);
        }
        if (this.hoverTextColor == 0) {
            this.setStyleProperty("hoverTextColor", themeConfig.button.parsedHoverTextColor);
        }
        if (this.holdTextColor == 0) {
            this.setStyleProperty("holdTextColor", themeConfig.button.parsedHoldTextColor);
        }
        this.currentColor = this.defaultColor;
        this.currentTextColor = this.defaultTextColor;
    }
}

