/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.layout;

import com.tttsaurus.ingameinfo.common.core.commonutils.MouseUtils;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Alignment;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Padding;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Pivot;
import com.tttsaurus.ingameinfo.common.core.gui.layout.Rect;
import com.tttsaurus.ingameinfo.common.core.gui.property.style.StyleProperty;
import com.tttsaurus.ingameinfo.common.core.gui.registry.RegisterElement;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderOpQueue;
import com.tttsaurus.ingameinfo.common.impl.gui.layout.DraggableContainerGroup;

@RegisterElement
public class DraggableGroup
extends DraggableContainerGroup {
    @StyleProperty
    public float overrideX = 0.0f;
    @StyleProperty
    public float overrideY = 0.0f;
    private float startDragPosX = 0.0f;
    private float startDragPosY = 0.0f;
    private boolean unlockDragging = false;
    private Rect dragArea = new Rect(0.0f, 0.0f, 0.0f, 0.0f);
    @StyleProperty
    public boolean restrictiveDragging = true;
    @StyleProperty(setterCallbackPre="nonNegativeFloatValidation")
    public float dragAreaWidth = 0.0f;
    @StyleProperty(setterCallbackPre="nonNegativeFloatValidation")
    public float dragAreaHeight = 0.0f;
    @StyleProperty(setterCallbackPre="alignmentValidation")
    public Alignment dragAreaAlignment = Alignment.NULL;
    @StyleProperty(setterCallbackPre="pivotValidation")
    public Pivot dragAreaPivot = Pivot.TOP_LEFT;
    @StyleProperty(setterCallbackPre="paddingValidation")
    public Padding dragAreaPadding = new Padding(0.0f, 0.0f, 0.0f, 0.0f);

    @Override
    public void calcRenderPos(Rect contextRect) {
        super.calcRenderPos(contextRect);
        this.dragArea.width = this.dragAreaWidth == 0.0f ? this.rect.width : this.dragAreaWidth;
        this.dragArea.height = this.dragAreaHeight == 0.0f ? this.rect.height : this.dragAreaHeight;
        this.dragArea.x = this.rect.x + this.rect.width * this.dragAreaAlignment.vertical;
        this.dragArea.y = this.rect.y + this.rect.height * this.dragAreaAlignment.horizontal;
        if (this.dragAreaPivot.vertical == 0.0f || this.dragAreaPivot.vertical == 0.5f) {
            this.dragArea.x += this.dragAreaPadding.left;
        }
        if (this.dragAreaPivot.vertical == 1.0f || this.dragAreaPivot.vertical == 0.5f) {
            this.dragArea.x -= this.dragAreaPadding.right;
        }
        if (this.dragAreaPivot.horizontal == 0.0f || this.dragAreaPivot.horizontal == 0.5f) {
            this.dragArea.y += this.dragAreaPadding.top;
        }
        if (this.dragAreaPivot.horizontal == 1.0f || this.dragAreaPivot.horizontal == 0.5f) {
            this.dragArea.y -= this.dragAreaPadding.bottom;
        }
        this.dragArea.x -= this.dragArea.width * this.dragAreaPivot.vertical;
        this.dragArea.y -= this.dragArea.height * this.dragAreaPivot.horizontal;
    }

    @Override
    public void onRenderUpdate(RenderOpQueue queue, boolean focused) {
        super.onRenderUpdate(queue, focused);
        if (!this.enabled) {
            return;
        }
        if (focused) {
            if (this.unlockDragging) {
                this.overrideX = this.rect.x + (float)MouseUtils.getMouseX() - this.startDragPosX;
                this.overrideY = this.rect.y + (float)MouseUtils.getMouseY() - this.startDragPosY;
                this.requestReCalc();
            }
            float x = MouseUtils.getMouseX();
            float y = MouseUtils.getMouseY();
            if (MouseUtils.isMouseDownLeft()) {
                if (this.dragArea.contains(x, y)) {
                    this.unlockDragging = true;
                }
                this.startDragPosX = x;
                this.startDragPosY = y;
            } else {
                this.unlockDragging = false;
            }
        } else {
            this.unlockDragging = false;
        }
    }
}

