/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.gui.render.op;

import com.tttsaurus.ingameinfo.common.core.gui.property.lerp.LerpableProperty;
import com.tttsaurus.ingameinfo.common.core.gui.render.RenderContext;
import com.tttsaurus.ingameinfo.common.core.gui.render.op.IRenderOp;
import com.tttsaurus.ingameinfo.common.core.gui.theme.ThemeConfig;
import com.tttsaurus.ingameinfo.common.core.render.RenderUtils;

public class SlidingTextOp
implements IRenderOp {
    public String text;
    public float x;
    public float y;
    public float scale;
    public LerpableProperty<Float> xShift = null;
    public boolean xShiftSign;
    public int color;
    public boolean shadow;

    public SlidingTextOp(String text, float x, float y, LerpableProperty<Float> xShift, boolean xShiftSign, float scale, int color, boolean shadow) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.xShift = xShift;
        this.xShiftSign = xShiftSign;
        this.scale = scale;
        this.color = color;
        this.shadow = shadow;
    }

    public SlidingTextOp(String text, float x, float y, float scale, int color, boolean shadow) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.scale = scale;
        this.color = color;
        this.shadow = shadow;
    }

    @Override
    public void readTheme(ThemeConfig theme) {
        if (this.color == 0) {
            this.color = theme.slidingText.parsedColor;
        }
    }

    @Override
    public void execute(RenderContext context) {
        float finalX = this.x;
        if (this.xShift != null) {
            finalX = this.xShiftSign ? (finalX += this.xShift.lerp(context.lerpAlpha).floatValue()) : (finalX -= this.xShift.lerp(context.lerpAlpha).floatValue());
        }
        RenderUtils.renderText(this.text, finalX, this.y, this.scale, this.color, this.shadow);
    }
}

