/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.common.impl.mvvm;

import com.tttsaurus.ingameinfo.common.core.mvvm.binding.Reactive;
import com.tttsaurus.ingameinfo.common.core.mvvm.binding.ReactiveObject;
import com.tttsaurus.ingameinfo.common.core.mvvm.viewmodel.ViewModel;
import com.tttsaurus.ingameinfo.common.impl.igievent.EventCenter;
import com.tttsaurus.ingameinfo.common.impl.mvvm.TemplateView;

public class TemplateViewModel
extends ViewModel<TemplateView> {
    @Reactive(targetUid="biome", property="text", initiativeSync=true)
    public ReactiveObject<String> biomeText = new ReactiveObject<String>(){};
    @Reactive(targetUid="tps/mspt", property="text", initiativeSync=true)
    public ReactiveObject<String> tpsMtpsText = new ReactiveObject<String>(){};
    @Reactive(targetUid="memoryBar", property="percentage", initiativeSync=true)
    public ReactiveObject<Float> memoryBarPercentage = new ReactiveObject<Float>(){};
    @Reactive(targetUid="memory", property="text", initiativeSync=true)
    public ReactiveObject<String> memoryText = new ReactiveObject<String>(){};
    @Reactive(targetUid="fps", property="text", initiativeSync=true)
    public ReactiveObject<String> fpsText = new ReactiveObject<String>(){};
    @Reactive(targetUid="igiFps", property="text", initiativeSync=true)
    public ReactiveObject<String> igiFpsText = new ReactiveObject<String>(){};
    @Reactive(targetUid="igiFbo", property="text", initiativeSync=true)
    public ReactiveObject<String> igiFboText = new ReactiveObject<String>(){};

    @Override
    public void onStart() {
        EventCenter.enterBiomeEvent.addListener((biomeName, registryName) -> this.biomeText.set("Biome: " + biomeName + ", " + registryName));
        EventCenter.gameTpsMsptEvent.addListener((tps, mspt) -> this.tpsMtpsText.set(String.format("TPS: %d, MSPT: %.3f ms/t", tps, mspt)));
        EventCenter.gameMemoryEvent.addListener((used, total) -> {
            int usedMb = (int)(used / 1024L / 1024L);
            int totalMb = (int)(total / 1024L / 1024L);
            this.memoryBarPercentage.set(Float.valueOf((float)usedMb / (float)totalMb));
            this.memoryText.set(usedMb + " MB / " + totalMb + " MB");
        });
        EventCenter.gameFpsEvent.addListener(fps -> this.fpsText.set("FPS: " + fps));
        EventCenter.igiGuiFpsEvent.addListener((fixedFps, renderFps) -> this.igiFpsText.set("IGI GUI FPS: " + fixedFps + ", " + renderFps));
        EventCenter.igiGuiFboRefreshRateEvent.addListener(rate -> this.igiFboText.set(String.format("FBO Refresh Rate: %.2f ", Float.valueOf(rate.floatValue() * 100.0f)) + "%"));
    }

    @Override
    public void onFixedUpdate(double deltaTime) {
    }
}

