/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.deprecated;

import com.tttsaurus.ingameinfo.common.core.render.GlResourceManager;
import com.tttsaurus.ingameinfo.common.core.render.IGlDisposable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class Mesh
implements IGlDisposable {
    private float[] vertices;
    private int[] indices;
    private ByteBuffer vertexBuffer;
    private ByteBuffer indexBuffer;
    private boolean setup;
    private int eboIndexOffset;
    private final int verticesLength;
    private final int indicesLength;
    private int vao;
    private int vbo;
    private int ebo;

    public int getVerticesLength() {
        return this.verticesLength;
    }

    public int getIndicesLength() {
        return this.indicesLength;
    }

    public int getVao() {
        return this.vao;
    }

    public int getVbo() {
        return this.vbo;
    }

    public int getEbo() {
        return this.ebo;
    }

    public boolean getSetup() {
        return this.setup;
    }

    protected int getEboIndexOffset() {
        return this.eboIndexOffset;
    }

    protected void setEboIndexOffset(int offset) {
        this.eboIndexOffset = offset;
    }

    public Mesh(float[] vertices, int[] indices) {
        this.vertices = vertices;
        this.indices = indices;
        this.verticesLength = vertices.length;
        this.indicesLength = indices.length;
        this.setup = false;
        this.eboIndexOffset = 0;
    }

    public void setup() {
        if (this.setup) {
            return;
        }
        int prevVao = GL11.glGetInteger((int)34229);
        int prevVbo = GL11.glGetInteger((int)34964);
        int prevEbo = GL11.glGetInteger((int)34965);
        this.vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        this.vertexBuffer = ByteBuffer.allocateDirect(this.vertices.length * 4).order(ByteOrder.nativeOrder());
        this.vertexBuffer.asFloatBuffer().put(this.vertices).flip();
        this.indexBuffer = ByteBuffer.allocateDirect(this.indices.length * 4).order(ByteOrder.nativeOrder());
        this.indexBuffer.asIntBuffer().put(this.indices).flip();
        this.vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferData((int)34962, (ByteBuffer)this.vertexBuffer, (int)35044);
        this.ebo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        GL15.glBufferData((int)34963, (ByteBuffer)this.indexBuffer, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)32, (long)12L);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)32, (long)20L);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)prevVao);
        GL15.glBindBuffer((int)34962, (int)prevVbo);
        GL15.glBindBuffer((int)34963, (int)prevEbo);
        this.vertices = null;
        this.indices = null;
        this.setup = true;
        GlResourceManager.addDisposable(this);
    }

    public void updateVerticesByMappedBuffer(float[] newVertices) {
        if (!this.setup) {
            throw new IllegalArgumentException("This mesh isn't set up so you can't update");
        }
        if (newVertices.length != this.verticesLength) {
            throw new IllegalArgumentException("New vertex array length must match existing length");
        }
        int prevVbo = GL11.glGetInteger((int)34964);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        ByteBuffer mappedBuffer = GL30.glMapBufferRange((int)34962, (long)0L, (long)((long)this.verticesLength * 4L), (int)34, (ByteBuffer)this.vertexBuffer);
        if (mappedBuffer == null) {
            throw new RuntimeException("Failed to map buffer");
        }
        mappedBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer().put(newVertices);
        GL15.glUnmapBuffer((int)34962);
        GL15.glBindBuffer((int)34962, (int)prevVbo);
    }

    public void updateVerticesByBufferSubData(float[] newVertices) {
        if (!this.setup) {
            throw new IllegalArgumentException("This mesh isn't set up so you can't update");
        }
        if (newVertices.length != this.verticesLength) {
            throw new IllegalArgumentException("New vertex array length must match existing length");
        }
        FloatBuffer vertexBuffer = ByteBuffer.allocateDirect(newVertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        vertexBuffer.put(newVertices).flip();
        int prevVbo = GL11.glGetInteger((int)34964);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferSubData((int)34962, (long)0L, (FloatBuffer)vertexBuffer);
        GL15.glBindBuffer((int)34962, (int)prevVbo);
    }

    public void updateIndicesByMappedBuffer(int[] newIndices) {
        if (!this.setup) {
            throw new IllegalArgumentException("This mesh isn't set up so you can't update");
        }
        if (newIndices.length != this.indicesLength) {
            throw new IllegalArgumentException("New index array length must match existing length");
        }
        int prevEbo = GL11.glGetInteger((int)34965);
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        ByteBuffer mappedBuffer = GL30.glMapBufferRange((int)34963, (long)0L, (long)((long)this.indicesLength * 4L), (int)34, (ByteBuffer)this.indexBuffer);
        if (mappedBuffer == null) {
            throw new RuntimeException("Failed to map buffer");
        }
        mappedBuffer.order(ByteOrder.nativeOrder()).asIntBuffer().put(newIndices);
        GL15.glUnmapBuffer((int)34963);
        GL15.glBindBuffer((int)34963, (int)prevEbo);
    }

    public void updateIndicesByBufferSubData(int[] newIndices) {
        if (!this.setup) {
            throw new IllegalArgumentException("This mesh isn't set up so you can't update");
        }
        if (newIndices.length != this.indicesLength) {
            throw new IllegalArgumentException("New index array length must match existing length");
        }
        IntBuffer indexBuffer = ByteBuffer.allocateDirect(newIndices.length * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        indexBuffer.put(newIndices).flip();
        int prevEbo = GL11.glGetInteger((int)34965);
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        GL15.glBufferSubData((int)34963, (long)0L, (IntBuffer)indexBuffer);
        GL15.glBindBuffer((int)34963, (int)prevEbo);
    }

    public void render() {
        if (!this.setup) {
            return;
        }
        int prevVao = GL11.glGetInteger((int)34229);
        int prevEbo = GL11.glGetInteger((int)34965);
        GL30.glBindVertexArray((int)this.vao);
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        GL11.glDrawElements((int)4, (int)this.indicesLength, (int)5125, (long)((long)this.eboIndexOffset * 4L));
        GL15.glBindBuffer((int)34963, (int)prevEbo);
        GL30.glBindVertexArray((int)prevVao);
    }

    @Override
    public void dispose() {
        GL30.glDeleteVertexArrays((int)this.vao);
        GL15.glDeleteBuffers((int)this.vbo);
        GL15.glDeleteBuffers((int)this.ebo);
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.setup = false;
    }
}

