/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ingameinfo.deprecated.mesh2d;

import com.tttsaurus.ingameinfo.deprecated.Mesh;
import com.tttsaurus.ingameinfo.deprecated.ScaledRes2NdcUtils;
import com.tttsaurus.ingameinfo.deprecated.VertexIndexUtils;

public class RoundedRectMesh
extends Mesh {
    private final int maxCornerSegment;
    private int cornerSegment;
    private float cornerRadius;
    private float x;
    private float y;
    private float width;
    private float height;
    private int vertexIndex = 0;

    public RoundedRectMesh(int maxCornerSegment) {
        super(new float[((maxCornerSegment + 1) * 4 + 1) * 8], new int[(maxCornerSegment * 4 + 4) * 3]);
        this.maxCornerSegment = maxCornerSegment;
        this.cornerSegment = maxCornerSegment;
    }

    public RoundedRectMesh setCornerRadius(float radius) {
        this.cornerRadius = radius;
        this.cornerSegment = Math.min(this.maxCornerSegment, Math.max(3, (int)(this.cornerRadius / 2.0f)));
        this.setEboIndexOffset((this.maxCornerSegment - this.cornerSegment) * 4 * 3);
        return this;
    }

    public RoundedRectMesh setRect(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    private void addArcVertices(float[] vertices, float cx, float cy, float startAngle, float endAngle, int segments) {
        startAngle -= 90.0f;
        endAngle -= 90.0f;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)Math.toRadians(startAngle + (endAngle - startAngle) * (float)i / (float)segments);
            float x = (float)((double)cx + Math.cos(angle) * (double)this.cornerRadius);
            float y = (float)((double)cy + Math.sin(angle) * (double)this.cornerRadius);
            vertices[this.vertexIndex * 8] = ScaledRes2NdcUtils.toNdcX(x);
            vertices[this.vertexIndex * 8 + 1] = ScaledRes2NdcUtils.toNdcY(y);
            vertices[this.vertexIndex * 8 + 2] = 0.0f;
            vertices[this.vertexIndex * 8 + 3] = 0.0f;
            vertices[this.vertexIndex * 8 + 4] = 0.0f;
            vertices[this.vertexIndex * 8 + 5] = 0.0f;
            vertices[this.vertexIndex * 8 + 6] = 0.0f;
            vertices[this.vertexIndex * 8 + 7] = 1.0f;
            ++this.vertexIndex;
        }
    }

    public void update() {
        float[] newVertices = new float[this.getVerticesLength()];
        float centerX = this.x + this.width / 2.0f;
        float centerY = this.y + this.height / 2.0f;
        newVertices[0] = ScaledRes2NdcUtils.toNdcX(centerX);
        newVertices[1] = ScaledRes2NdcUtils.toNdcY(centerY);
        newVertices[2] = 0.0f;
        newVertices[3] = 0.0f;
        newVertices[4] = 0.0f;
        newVertices[5] = 0.0f;
        newVertices[6] = 0.0f;
        newVertices[7] = 1.0f;
        this.vertexIndex = 1;
        this.addArcVertices(newVertices, this.x + this.width - this.cornerRadius, this.y + this.cornerRadius, 0.0f, 90.0f, this.cornerSegment);
        this.addArcVertices(newVertices, this.x + this.width - this.cornerRadius, this.y + this.height - this.cornerRadius, 90.0f, 180.0f, this.cornerSegment);
        this.addArcVertices(newVertices, this.x + this.cornerRadius, this.y + this.height - this.cornerRadius, 180.0f, 270.0f, this.cornerSegment);
        this.addArcVertices(newVertices, this.x + this.cornerRadius, this.y + this.cornerRadius, 270.0f, 360.0f, this.cornerSegment);
        int[] newIndices = new int[this.getIndicesLength()];
        for (int i = 1; i < this.vertexIndex; ++i) {
            float y2;
            float x2;
            int offset = (this.maxCornerSegment - this.cornerSegment) * 4;
            int i1 = i;
            int i2 = i + 1;
            float x1 = newVertices[i * 8];
            float y1 = newVertices[i * 8 + 1];
            if (i == this.vertexIndex - 1) {
                x2 = newVertices[8];
                y2 = newVertices[9];
                i2 = 1;
            } else {
                x2 = newVertices[(i + 1) * 8];
                y2 = newVertices[(i + 1) * 8 + 1];
            }
            if (VertexIndexUtils.isCcw(newVertices[0], newVertices[1], x1, y2, x2, y2)) {
                newIndices[(i - 1 + offset) * 3] = 0;
                newIndices[(i - 1 + offset) * 3 + 1] = i1;
                newIndices[(i - 1 + offset) * 3 + 2] = i2;
                continue;
            }
            newIndices[(i - 1 + offset) * 3] = 0;
            newIndices[(i - 1 + offset) * 3 + 1] = i2;
            newIndices[(i - 1 + offset) * 3 + 2] = i1;
        }
        this.updateVerticesByBufferSubData(newVertices);
        this.updateIndicesByBufferSubData(newIndices);
    }
}

