/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.rollingdowninthedeep;

import dev.enjarai.rollingdowninthedeep.config.SwimConfig;
import net.minecraft.util.SmoothDouble;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ModConfig;

public class CameraModifiers {
    public static final SmoothDouble YAW_SMOOTHER = new SmoothDouble();
    public static final SmoothDouble PITCH_SMOOTHER = new SmoothDouble();
    public static final SmoothDouble ROLL_SMOOTHER = new SmoothDouble();

    public static RotationInstant smoothCamera(RotationInstant rotationInstant, RollContext context) {
        double smoothedYaw = YAW_SMOOTHER.getNewDeltaValue(rotationInstant.yaw(), ModConfig.INSTANCE.getSmoothing().yaw * context.getRenderDelta());
        double smoothedPitch = PITCH_SMOOTHER.getNewDeltaValue(rotationInstant.pitch(), ModConfig.INSTANCE.getSmoothing().pitch * context.getRenderDelta());
        return RotationInstant.of((double)smoothedPitch, (double)smoothedYaw, (double)rotationInstant.roll());
    }

    public static RotationInstant configureRotation(RotationInstant rotationInstant, RollContext context) {
        double pitch = rotationInstant.pitch();
        double yaw = rotationInstant.yaw();
        double roll = rotationInstant.roll();
        if (!SwimConfig.INSTANCE.swapYawAndRoll) {
            double temp = yaw;
            yaw = roll;
            roll = temp;
        }
        if (ModConfig.INSTANCE.getInvertPitch()) {
            pitch = -pitch;
        }
        return RotationInstant.of((double)pitch, (double)yaw, (double)roll);
    }
}

