/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.rollingdowninthedeep;

import dev.enjarai.rollingdowninthedeep.CameraModifiers;
import dev.enjarai.rollingdowninthedeep.StrafeRollModifiers;
import dev.enjarai.rollingdowninthedeep.SwimKeybindings;
import dev.enjarai.rollingdowninthedeep.config.SwimConfig;
import dev.enjarai.rollingdowninthedeep.config.SwimConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.SmoothDouble;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.api.RollEntity;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.event.RollGroup;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.flight.RotationModifiers;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="rolling_down_in_the_deep", dist={Dist.CLIENT})
public class RollingDownInTheDeep {
    public static final String MOD_ID = "rolling_down_in_the_deep";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rolling_down_in_the_deep");
    public static final RollGroup SWIM_GROUP = RollGroup.of((ResourceLocation)RollingDownInTheDeep.id("swimming"));
    public static final RollGroup DABR_GROUP = RollGroup.of((ResourceLocation)DoABarrelRoll.id((String)"fall_flying"));
    public static final SmoothDouble YAW_SMOOTHER = new SmoothDouble();
    public static final SmoothDouble PITCH_SMOOTHER = new SmoothDouble();
    public static final SmoothDouble ROLL_SMOOTHER = new SmoothDouble();
    public static final Minecraft client = Minecraft.getInstance();

    public RollingDownInTheDeep(IEventBus bus, ModContainer modContainer) {
        SwimConfig.touch();
        SWIM_GROUP.trueIf(RollingDownInTheDeep::shouldRoll);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(container, parent) -> SwimConfigScreen.create(parent)));
        bus.addListener(RegisterKeyMappingsEvent.class, SwimKeybindings::register);
        RollEvents.EARLY_CAMERA_MODIFIERS.register(context -> context.useModifier(CameraModifiers::configureRotation), 1000, () -> (Boolean)SWIM_GROUP.get() != false && (Boolean)DABR_GROUP.get() == false);
        RollEvents.EARLY_CAMERA_MODIFIERS.register(context -> context.useModifier(StrafeRollModifiers::applyStrafeRoll), 2000, () -> (Boolean)SWIM_GROUP.get() != false && (Boolean)DABR_GROUP.get() == false);
        RollEvents.LATE_CAMERA_MODIFIERS.register(context -> context.useModifier(RotationModifiers.smoothing((SmoothDouble)PITCH_SMOOTHER, (SmoothDouble)YAW_SMOOTHER, (SmoothDouble)ROLL_SMOOTHER, (Sensitivity)SwimConfig.INSTANCE.smoothing.values)), 3000, () -> (Boolean)SWIM_GROUP.get() != false && (Boolean)DABR_GROUP.get() == false && SwimConfig.INSTANCE.smoothing.smoothingEnabled);
    }

    public static Vector3f movementInputToVelocity(LocalPlayer player, Vector3f moveInput, float speed) {
        Matrix3d matrix = new Matrix3d().rotateY((double)(-player.getYRot()) * (Math.PI / 180)).rotateX((double)player.getXRot() * (Math.PI / 180)).rotateZ((double)((RollEntity)player).doABarrelRoll$getRoll() * (Math.PI / 180));
        if (!SwimConfig.INSTANCE.strafeDoStrafe) {
            moveInput.x = 0.0f;
        }
        if (RollingDownInTheDeep.client.options.keyJump.isDown()) {
            moveInput.add(0.0f, 1.0f, 0.0f);
            speed += 0.006f;
        }
        if (RollingDownInTheDeep.client.options.keyShift.isDown()) {
            moveInput.add(0.0f, -1.0f, 0.0f);
            speed += 0.006f;
        }
        moveInput.mul((Matrix3dc)matrix);
        if (moveInput.lengthSquared() > 1.0f) {
            moveInput.normalize();
        }
        moveInput.mul(speed);
        return moveInput;
    }

    public static boolean shouldRoll() {
        LocalPlayer player = Minecraft.getInstance().player;
        return RollingDownInTheDeep.enabled() && player != null && player.isSwimming() && player.isUnderWater();
    }

    public static boolean enabled() {
        return SwimConfig.INSTANCE.enabled;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

