/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.rollingdowninthedeep.compat.yacl;

import dev.enjarai.rollingdowninthedeep.RollingDownInTheDeep;
import dev.enjarai.rollingdowninthedeep.SwimKeybindings;
import dev.enjarai.rollingdowninthedeep.config.SwimConfig;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class YACLImplementation {
    public static Screen generateConfigScreen(Screen parent) {
        return YetAnotherConfigLib.createBuilder().title((Component)YACLImplementation.getText("title")).category(ConfigCategory.createBuilder().name((Component)YACLImplementation.getText("general")).option(YACLImplementation.getBooleanOption("general", "mod_enabled", false, false).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"config.rolling_down_in_the_deep.general.mod_enabled.description", (Object[])new Object[]{SwimKeybindings.TOGGLE_ENABLED.getTranslatedKeyMessage()})}).build()).binding((Object)true, () -> SwimConfig.INSTANCE.enabled, value -> {
            SwimConfig.INSTANCE.enabled = value;
        }).build()).option(YACLImplementation.getBooleanOption("general", "persistent_swimming", true, false).binding((Object)true, () -> SwimConfig.INSTANCE.persistentSwimming, value -> {
            SwimConfig.INSTANCE.persistentSwimming = value;
        }).build()).option(YACLImplementation.getBooleanOption("general", "swap_yaw_and_roll", true, false).binding((Object)false, () -> SwimConfig.INSTANCE.swapYawAndRoll, value -> {
            SwimConfig.INSTANCE.swapYawAndRoll = value;
        }).build()).group(OptionGroup.createBuilder().name((Component)YACLImplementation.getText("general", "strafing")).option(YACLImplementation.getOption(Double.class, "general.strafing", "yaw_strength", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.1, 5.0, 0.1)).binding((Object)1.0, () -> SwimConfig.INSTANCE.strafeYawStrength, value -> {
            SwimConfig.INSTANCE.strafeYawStrength = value;
        }).build()).option(YACLImplementation.getOption(Double.class, "general.strafing", "roll_strength", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.1, 5.0, 0.1)).binding((Object)0.2, () -> SwimConfig.INSTANCE.strafeRollStrength, value -> {
            SwimConfig.INSTANCE.strafeRollStrength = value;
        }).build()).option(YACLImplementation.getBooleanOption("general.strafing", "do_strafe", true, false).binding((Object)true, () -> SwimConfig.INSTANCE.strafeDoStrafe, value -> {
            SwimConfig.INSTANCE.strafeDoStrafe = value;
        }).build()).build()).group(OptionGroup.createBuilder().name((Component)YACLImplementation.getText("general", "strafe_velocity")).option(YACLImplementation.getBooleanOption("general.strafe_velocity", "do_velocity", true, false).binding((Object)true, () -> SwimConfig.INSTANCE.velocityEnable, value -> {
            SwimConfig.INSTANCE.velocityEnable = value;
        }).build()).option(YACLImplementation.getOption(Double.class, "general.strafe_velocity", "clamp_min", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.0, 4.0, 0.05)).binding((Object)0.4, () -> SwimConfig.INSTANCE.velocityMin, value -> {
            SwimConfig.INSTANCE.velocityMin = value;
        }).build()).option(YACLImplementation.getOption(Double.class, "general.strafe_velocity", "clamp_max", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.0, 4.0, 0.05)).binding((Object)1.0, () -> SwimConfig.INSTANCE.velocityMax, value -> {
            SwimConfig.INSTANCE.velocityMax = value;
        }).build()).option(YACLImplementation.getOption(Double.class, "general.strafe_velocity", "scale", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.0, 90.0, 0.05)).binding((Object)8.65, () -> SwimConfig.INSTANCE.velocityScale, value -> {
            SwimConfig.INSTANCE.velocityScale = value;
        }).build()).build()).build()).category(ConfigCategory.createBuilder().name((Component)YACLImplementation.getText("smoothing")).option(YACLImplementation.getBooleanOption("smoothing", "enabled", false, false).binding((Object)true, () -> SwimConfig.INSTANCE.smoothing.smoothingEnabled, value -> {
            SwimConfig.INSTANCE.smoothing.smoothingEnabled = value;
        }).build()).option(YACLImplementation.getBooleanOption("smoothing", "strafe_enabled", false, false).binding((Object)true, () -> SwimConfig.INSTANCE.smoothing.strafeSmoothingEnabled, value -> {
            SwimConfig.INSTANCE.smoothing.strafeSmoothingEnabled = value;
        }).build()).group(OptionGroup.createBuilder().name((Component)YACLImplementation.getText("smoothing", "strength")).option(YACLImplementation.getOption(Double.class, "smoothing.strength", "pitch", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.1, 5.0, 0.1)).binding((Object)0.5, () -> SwimConfig.INSTANCE.smoothing.values.pitch, value -> {
            SwimConfig.INSTANCE.smoothing.values.pitch = value;
        }).build()).option(YACLImplementation.getOption(Double.class, "smoothing.strength", "yaw", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.1, 5.0, 0.1)).binding((Object)0.5, () -> SwimConfig.INSTANCE.smoothing.values.yaw, value -> {
            SwimConfig.INSTANCE.smoothing.values.yaw = value;
        }).build()).option(YACLImplementation.getOption(Double.class, "smoothing.strength", "roll", false, false).controller(option -> YACLImplementation.getDoubleSlider((Option<Double>)option, 0.1, 5.0, 0.1)).binding((Object)0.5, () -> SwimConfig.INSTANCE.smoothing.values.roll, value -> {
            SwimConfig.INSTANCE.smoothing.values.roll = value;
        }).build()).build()).build()).save(SwimConfig.INSTANCE::save).build().generateScreen(parent);
    }

    private static <T> Option.Builder<T> getOption(Class<T> clazz, String category, String key, boolean description, boolean image) {
        Option.Builder builder = Option.createBuilder().name((Component)YACLImplementation.getText(category, key));
        OptionDescription.Builder descBuilder = OptionDescription.createBuilder();
        if (description) {
            descBuilder.text(new Component[]{YACLImplementation.getText(category, key + ".description")});
        }
        if (image) {
            descBuilder.image(RollingDownInTheDeep.id("textures/gui/config/images/" + category + "/" + key + ".png"), 480, 275);
        }
        builder.description(descBuilder.build());
        return builder;
    }

    private static Option.Builder<Boolean> getBooleanOption(String category, String key, boolean description, boolean image) {
        return YACLImplementation.getOption(Boolean.class, category, key, description, image).controller(TickBoxControllerBuilder::create);
    }

    private static MutableComponent getText(String category, String key) {
        return Component.translatable((String)Util.makeDescriptionId((String)"config", (ResourceLocation)RollingDownInTheDeep.id(key).withPrefix(category + "/")));
    }

    private static MutableComponent getText(String key) {
        return Component.translatable((String)Util.makeDescriptionId((String)"config", (ResourceLocation)RollingDownInTheDeep.id(key)));
    }

    private static DoubleSliderControllerBuilder getDoubleSlider(Option<Double> option, double min, double max, double step) {
        return (DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create(option).range((Number)min, (Number)max)).step((Number)step);
    }
}

