/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.gui;

import java.util.List;
import java.util.Objects;
import me.senseiwells.chunkdebug.client.ChunkDebugClient;
import me.senseiwells.chunkdebug.client.gui.ChunkDebugMap;
import me.senseiwells.chunkdebug.client.gui.ChunkSelection;
import me.senseiwells.chunkdebug.client.gui.ChunkSelectionInfo;
import me.senseiwells.chunkdebug.client.gui.widget.ArrowButton;
import me.senseiwells.chunkdebug.client.gui.widget.IntegerEditbox;
import me.senseiwells.chunkdebug.client.gui.widget.NamedButton;
import me.senseiwells.chunkdebug.client.gui.widget.ToggleButton;
import me.senseiwells.chunkdebug.client.utils.RenderUtils;
import me.senseiwells.keybinds.api.InputKeys;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ChunkDebugScreen
extends class_437 {
    private static final int MENU_PADDING = 3;
    private final ChunkDebugMap map;
    private final class_437 parent;
    private boolean draggingMinimap = false;
    private ToggleButton breakdown;
    private ToggleButton settings;
    private ArrowButton dimensionLeft;
    private ArrowButton dimensionRight;
    private ArrowButton minimapLeft;
    private ArrowButton minimapRight;
    private ArrowButton minimapCornerLeft;
    private ArrowButton minimapCornerRight;
    private NamedButton returnToPlayer;
    private ArrowButton clustersLeft;
    private ArrowButton clustersRight;
    private IntegerEditbox chunkPosX;
    private IntegerEditbox chunkPosZ;
    private ToggleButton showStages;
    private ToggleButton showTickets;
    private ToggleButton showMinimap;
    private IntegerEditbox chunkRetention;

    public ChunkDebugScreen(ChunkDebugMap map, @Nullable class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"chunk-debug.screen.title"));
        this.map = map;
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.breakdown = new ToggleButton(this.field_22789 - 20, this.field_22790 - 20, 15);
        this.breakdown.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.info.breakdown.toggle")));
        this.breakdown.setToggled(true);
        this.method_37063((class_364)this.breakdown);
        this.settings = new ToggleButton(5, this.field_22790 - 20, 15);
        this.settings.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.settings.toggle")));
        this.settings.setToggled(true);
        this.method_37063((class_364)this.settings);
        this.dimensionLeft = new ArrowButton(ArrowButton.Direction.LEFT, 9, 0, 15, () -> this.map.incrementDimension(-1));
        this.method_37063((class_364)this.dimensionLeft);
        this.dimensionRight = new ArrowButton(ArrowButton.Direction.RIGHT, 0, 0, 15, () -> this.map.incrementDimension(1));
        this.method_37063((class_364)this.dimensionRight);
        this.minimapLeft = new ArrowButton(ArrowButton.Direction.LEFT, 0, 0, 15, this.map::previousMinimap);
        this.method_37063((class_364)this.minimapLeft);
        this.minimapRight = new ArrowButton(ArrowButton.Direction.RIGHT, 0, 0, 15, this.map::nextMinimap);
        this.method_37063((class_364)this.minimapRight);
        this.minimapCornerLeft = new ArrowButton(ArrowButton.Direction.LEFT, 0, 0, 15, () -> {
            this.map.config.minimapCorner = this.map.config.minimapCorner.previous();
            this.map.config.minimapOffsetY = 0.0;
            this.map.config.minimapOffsetX = 0.0;
        });
        this.method_37063((class_364)this.minimapCornerLeft);
        this.minimapCornerRight = new ArrowButton(ArrowButton.Direction.RIGHT, 0, 0, 15, () -> {
            this.map.config.minimapCorner = this.map.config.minimapCorner.next();
            this.map.config.minimapOffsetY = 0.0;
            this.map.config.minimapOffsetX = 0.0;
        });
        this.method_37063((class_364)this.minimapCornerRight);
        class_5250 player = class_2561.method_43471((String)"chunk-debug.settings.return");
        this.returnToPlayer = new NamedButton(0, 0, 0, 15, (class_2561)player, this.map::returnToPlayer);
        this.method_37063((class_364)this.returnToPlayer);
        this.clustersLeft = new ArrowButton(ArrowButton.Direction.LEFT, 0, 0, 15, () -> this.map.jumpToCluster(-1));
        this.method_37063((class_364)this.clustersLeft);
        this.clustersRight = new ArrowButton(ArrowButton.Direction.RIGHT, 0, 0, 15, () -> this.map.jumpToCluster(1));
        this.method_37063((class_364)this.clustersRight);
        this.chunkPosX = new IntegerEditbox(this.field_22793, 40, 15, this.map::setMapCenterX);
        this.method_37063((class_364)this.chunkPosX);
        this.chunkPosZ = new IntegerEditbox(this.field_22793, 40, 15, this.map::setMapCenterZ);
        this.method_37063((class_364)this.chunkPosZ);
        this.showStages = new ToggleButton(0, 0, 15, b -> {
            this.map.config.showStages = b;
        });
        this.showStages.setToggled(this.map.config.showStages);
        this.method_37063((class_364)this.showStages);
        this.showTickets = new ToggleButton(0, 0, 15, b -> {
            this.map.config.showTickets = b;
        });
        this.showTickets.setToggled(this.map.config.showTickets);
        this.method_37063((class_364)this.showTickets);
        this.showMinimap = new ToggleButton(0, 0, 15, b -> {
            this.map.config.showMinimap = b;
        });
        this.showMinimap.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.settings.visibility.minimap.tooltip")));
        this.showMinimap.setToggled(this.map.config.showMinimap);
        this.method_37063((class_364)this.showMinimap);
        this.chunkRetention = new IntegerEditbox(this.field_22793, 30, 15, i -> {
            this.map.config.chunkRetention = i;
        });
        this.chunkRetention.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chunk-debug.settings.visibility.unload.tooltip")));
        this.chunkRetention.setIntValue(this.map.config.chunkRetention);
        this.method_37063((class_364)this.chunkRetention);
    }

    protected void method_48640() {
        this.breakdown.method_48229(this.field_22789 - 20, this.field_22790 - 20);
        this.settings.method_46419(this.field_22790 - 20);
    }

    public void method_49589() {
        ChunkDebugClient.getInstance().startWatching(this.map.dimension());
    }

    public void method_25432() {
        if (this.map.minimap == ChunkDebugMap.Minimap.NONE) {
            ChunkDebugClient.getInstance().stopWatching();
            this.map.resetStates();
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
        this.method_57734(graphics);
        ChunkDebugMap.DimensionState state = this.map.state();
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate(state.offsetX, state.offsetY);
        graphics.method_51448().scale(state.scale, state.scale);
        this.map.renderMap(graphics, state);
        this.map.renderChunkSelecting(graphics, mouseX, mouseY);
        this.map.renderChunkClusters(graphics);
        graphics.method_51448().popMatrix();
        if (this.showMinimap.isToggled()) {
            this.map.renderMinimap(graphics);
        }
        this.renderChunkSelectionMenu(graphics, state);
        this.renderSettingsMenu(graphics);
        if (!this.chunkPosX.method_25370()) {
            this.chunkPosX.setIntValue(this.map.center.field_9181);
        }
        if (!this.chunkPosZ.method_25370()) {
            this.chunkPosZ.setIntValue(this.map.center.field_9180);
        }
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public boolean method_25404(class_11908 event) {
        if (super.method_25404(event)) {
            return true;
        }
        if (event.comp_4795() == 290) {
            boolean visible = this.settings.isToggled() || this.breakdown.isToggled();
            this.settings.setToggled(!visible);
            this.breakdown.setToggled(!visible);
            return true;
        }
        if (event.comp_4795() == 82 && event.method_74240()) {
            ChunkDebugClient.getInstance().refresh();
            this.map.resetData();
            return true;
        }
        InputKeys keys = ChunkDebugClient.getInstance().keybind.keys();
        if (keys.size() == 1 && keys.isLastKey(class_3675.method_15985((class_11908)event))) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
            return;
        }
        super.method_25419();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25402(class_11909 event, boolean bl) {
        if (super.method_25402(event, bl)) {
            return true;
        }
        this.chunkPosX.method_25365(false);
        this.chunkPosZ.method_25365(false);
        this.chunkRetention.method_25365(false);
        if (event.method_74245() == 1) {
            ChunkDebugMap.DimensionState state = this.map.state();
            state.first = this.map.convertScreenToChunkPos(event.comp_4798(), event.comp_4799());
            return true;
        }
        if (event.method_74245() == 0 && this.showMinimap.isToggled() && this.map.getMinimapBounds().contains(event.comp_4798(), event.comp_4799())) {
            this.draggingMinimap = true;
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 event) {
        ChunkDebugMap.DimensionState state = this.map.state();
        if (state.first != null && event.method_74245() == 1) {
            ChunkSelection selection = new ChunkSelection(state.first, this.map.convertScreenToChunkPos(event.comp_4798(), event.comp_4799()));
            state.first = null;
            state.selection = selection.equals(state.selection) ? null : selection;
            return true;
        }
        if (event.method_74245() == 0) {
            this.draggingMinimap = false;
        }
        return super.method_25406(event);
    }

    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        ChunkDebugMap.DimensionState state = this.map.state();
        if (event.method_74245() == 0) {
            if (this.draggingMinimap) {
                this.map.config.minimapOffsetX += dragX;
                this.map.config.minimapOffsetY += dragY;
            } else {
                state.offsetX += (float)dragX;
                state.offsetY += (float)dragY;
                this.map.updateCenter();
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.map.getMinimapBounds().contains(mouseX, mouseY)) {
            this.map.config.minimapSize = class_3532.method_15340((int)(this.map.config.minimapSize + (int)scrollY), (int)20, (int)200);
            return true;
        }
        ChunkDebugMap.DimensionState state = this.map.state();
        double currentX = (mouseX - (double)state.offsetX) / (double)state.scale;
        double currentY = (mouseY - (double)state.offsetY) / (double)state.scale;
        state.scale = class_3532.method_15363((float)(state.scale + (float)scrollY * 0.5f), (float)1.0f, (float)64.0f);
        state.offsetX = (float)(mouseX - currentX * (double)state.scale);
        state.offsetY = (float)(mouseY - currentY * (double)state.scale);
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    private void renderSettingsMenu(class_332 graphics) {
        RenderUtils.setVisible(this.settings.isToggled(), new class_339[]{this.dimensionLeft, this.dimensionRight, this.minimapLeft, this.minimapRight, this.minimapCornerLeft, this.minimapCornerRight, this.clustersLeft, this.clustersRight, this.returnToPlayer, this.showMinimap, this.showStages, this.showTickets, this.chunkPosX, this.chunkPosZ, this.chunkRetention});
        if (!this.settings.isToggled()) {
            return;
        }
        graphics.method_51448().pushMatrix();
        class_5250 title = class_2561.method_43471((String)"chunk-debug.settings").method_54663(-932399890);
        class_5250 player = class_2561.method_43471((String)"chunk-debug.settings.return");
        class_5250 clusters = class_2561.method_43471((String)"chunk-debug.settings.clusters");
        class_5250 stages = class_2561.method_43471((String)"chunk-debug.settings.visibility.stages");
        class_5250 tickets = class_2561.method_43471((String)"chunk-debug.settings.visibility.tickets");
        class_5250 minimap = class_2561.method_43471((String)"chunk-debug.settings.visibility.minimap");
        class_5250 corner = class_2561.method_43471((String)"chunk-debug.settings.minimap.corner");
        class_5250 fade = class_2561.method_43471((String)"chunk-debug.settings.visibility.unload");
        int padding = 3;
        int width = Math.max(this.map.dimensionWidth, RenderUtils.maxWidth(this.field_22793, (class_2561)clusters, new class_2561[]{minimap})) + 2 * padding + 30;
        width = Math.max(width, RenderUtils.maxWidth(this.field_22793, (class_2561)title, new class_2561[]{player}));
        width = Math.max(width, RenderUtils.maxWidth(this.field_22793, (class_2561)stages, new class_2561[]{tickets, fade}) + padding + 15);
        int minX = padding + 1 - 1;
        int minY = padding + 1 - 1;
        int maxX = padding + (width += 4 * padding);
        int maxY = this.field_22790 - padding;
        int centerX = (maxX + minX) / 2;
        graphics.method_25294(minX, minY, maxX, maxY, -936035512);
        graphics.method_27535(this.field_22793, (class_2561)title, minX + padding, minY + padding, -1);
        Objects.requireNonNull(this.field_22793);
        int offsetY = minY + padding * 2 + 9;
        int gap = padding + 15;
        class_2561 mode = this.map.getMinimapName();
        RenderUtils.options(graphics, this.field_22793, minX, maxX, offsetY, padding, mode, this.minimapLeft, this.minimapRight);
        class_5250 dimension = class_2561.method_43470((String)this.map.dimension().method_29177().toString());
        RenderUtils.options(graphics, this.field_22793, minX, maxX, offsetY += gap + 3, padding, (class_2561)dimension, this.dimensionLeft, this.dimensionRight);
        RenderUtils.options(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)clusters, this.clustersLeft, this.clustersRight);
        class_5250 x = class_2561.method_43470((String)"X");
        class_5250 z = class_2561.method_43470((String)"Z");
        this.chunkPosX.method_25358(centerX - minX - 5 * padding - this.field_22793.method_27525((class_5348)x) + 2);
        this.chunkPosZ.method_25358(maxX - centerX - 5 * padding - this.field_22793.method_27525((class_5348)z) + 2);
        RenderUtils.optionRight(graphics, this.field_22793, minX, centerX + padding / 2, offsetY += gap, padding, (class_2561)x, (class_339)this.chunkPosX);
        RenderUtils.optionRight(graphics, this.field_22793, centerX - padding / 2, maxX, offsetY, padding, (class_2561)z, (class_339)this.chunkPosZ);
        this.returnToPlayer.method_48229(minX + padding, offsetY += gap);
        this.returnToPlayer.method_25358(maxX - minX - 2 * padding);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap + 3, padding, (class_2561)stages, (class_339)this.showStages);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)tickets, (class_339)this.showTickets);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)minimap, (class_339)this.showMinimap);
        RenderUtils.options(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)corner, this.minimapCornerLeft, this.minimapCornerRight);
        RenderUtils.optionLeft(graphics, this.field_22793, minX, maxX, offsetY += gap, padding, (class_2561)fade, (class_339)this.chunkRetention);
        graphics.method_51448().popMatrix();
    }

    private void renderChunkSelectionMenu(class_332 graphics, ChunkDebugMap.DimensionState state) {
        boolean bl = this.breakdown.field_22764 = state.selection != null;
        if (!this.breakdown.field_22764 || !this.breakdown.isToggled()) {
            return;
        }
        graphics.method_51448().pushMatrix();
        ChunkSelectionInfo info = ChunkSelectionInfo.create(state.selection, state.chunks());
        int padding = 3;
        int width = info.getMaxWidth(this.field_22793) + 4 * padding;
        int minX = this.field_22789 - width - padding;
        int minY = padding + 1 - 1;
        int maxX = this.field_22789 - padding;
        int maxY = this.field_22790 - padding;
        graphics.method_25294(minX, minY, maxX, maxY, -936035512);
        graphics.method_27535(this.field_22793, info.title(), minX + padding, minY + padding, -1);
        minX += padding;
        maxX -= padding;
        int offsetY = minY + padding * 2;
        for (List<class_2561> section : info.sections()) {
            offsetY = this.renderInnerChunkSelectionInfo(graphics, section, padding, minX, maxX, offsetY);
        }
        graphics.method_51448().popMatrix();
    }

    private int renderInnerChunkSelectionInfo(class_332 graphics, List<class_2561> lines, int padding, int minX, int maxX, int offsetY) {
        if (lines.isEmpty()) {
            return offsetY;
        }
        Objects.requireNonNull(this.field_22793);
        int increment = 9 + padding;
        int maxY = offsetY + increment * (lines.size() + 1);
        graphics.method_25294(minX, offsetY + increment - padding, maxX, maxY, 0x55000000);
        for (class_2561 line : lines) {
            Objects.requireNonNull(this.field_22793);
            graphics.method_27535(this.field_22793, line, minX + padding, offsetY += 9 + padding, -1);
        }
        return maxY - padding;
    }
}

