/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.gui;

import java.util.List;
import java.util.Objects;
import java.util.stream.LongStream;
import net.minecraft.class_1923;

public class ChunkSelection {
    public static final ChunkSelection EMPTY = new ChunkSelection(0, 0, 0, 0);
    public final int minX;
    public final int minZ;
    public final int maxX;
    public final int maxZ;

    public ChunkSelection(class_1923 first, class_1923 second) {
        this(first.field_9181, first.field_9180, second.field_9181, second.field_9180);
    }

    public ChunkSelection(int x1, int z1, int x2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxZ = Math.max(z1, z2);
    }

    public int sizeX() {
        return this.maxX - this.minX + 1;
    }

    public int sizeZ() {
        return this.maxZ - this.minZ + 1;
    }

    public boolean isSingleChunk() {
        return this.minX == this.maxX && this.minZ == this.maxZ;
    }

    public class_1923 getMinChunkPos() {
        return new class_1923(this.minX, this.minZ);
    }

    public class_1923 getCenterChunkPos() {
        return new class_1923((this.minX + this.maxX) / 2, (this.minZ + this.maxZ) / 2);
    }

    public class_1923 getMaxChunkPos() {
        return new class_1923(this.maxX, this.maxZ);
    }

    public LongStream stream() {
        return LongStream.rangeClosed(this.minX, this.maxX).flatMap(x -> LongStream.rangeClosed(this.minZ, this.maxZ).map(z -> class_1923.method_8331((int)((int)x), (int)((int)z))));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChunkSelection)) {
            return false;
        }
        ChunkSelection that = (ChunkSelection)o;
        return this.minX == that.minX && this.minZ == that.minZ && this.maxX == that.maxX && this.maxZ == that.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minZ, this.maxX, this.maxZ);
    }

    public static ChunkSelection fromPositions(List<class_1923> positions) {
        if (positions.isEmpty()) {
            return EMPTY;
        }
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_1923 pos : positions) {
            minX = Math.min(minX, pos.field_9181);
            minZ = Math.min(minZ, pos.field_9180);
            maxX = Math.max(maxX, pos.field_9181);
            maxZ = Math.max(maxZ, pos.field_9180);
        }
        return new ChunkSelection(minX, minZ, maxX, maxZ);
    }
}

