/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.gui;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.senseiwells.chunkdebug.client.gui.ChunkSelection;
import me.senseiwells.chunkdebug.common.utils.ChunkData;
import me.senseiwells.chunkdebug.common.utils.ExtraStreamCodecs;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_3194;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public record ChunkSelectionInfo(class_2561 title, List<List<class_2561>> sections) {
    public int getMaxWidth(class_327 font) {
        int width = 0;
        for (class_2561 component : Iterables.concat(this.sections)) {
            width = Math.max(width, font.method_27525((class_5348)component));
        }
        return Math.max(width, font.method_27525((class_5348)this.title));
    }

    public static ChunkSelectionInfo create(ChunkSelection selection, Long2ObjectMap<ChunkData> chunks) {
        class_5250 title;
        ArrayList<class_5250> location = new ArrayList<class_5250>();
        ArrayList<class_5250> status = new ArrayList<class_5250>();
        ArrayList<class_5250> tickets = new ArrayList<class_5250>();
        ArrayList<class_5250> stages = new ArrayList<class_5250>();
        ArrayList<class_5250> unloading = new ArrayList<class_5250>();
        if (selection.isSingleChunk()) {
            class_1923 pos = selection.getCenterChunkPos();
            title = class_2561.method_43471((String)"chunk-debug.info.breakdown.chunk").method_54663(-932399890);
            location.add(class_2561.method_43469((String)"chunk-debug.info.location", (Object[])new Object[]{ChunkSelectionInfo.prettify(pos)}));
            ChunkData data = (ChunkData)chunks.get(pos.method_8324());
            if (data != null) {
                class_2806 stage;
                status.add(class_2561.method_43469((String)"chunk-debug.info.status", (Object[])new Object[]{ChunkSelectionInfo.prettify(data.status())}));
                status.add(class_2561.method_43469((String)"chunk-debug.info.status.level", (Object[])new Object[]{ChunkSelectionInfo.prettify(data.statusLevel())}));
                status.add(class_2561.method_43469((String)"chunk-debug.info.status.level.ticking", (Object[])new Object[]{ChunkSelectionInfo.prettify(data.tickingStatusLevel())}));
                if (!data.tickets().isEmpty()) {
                    tickets.add(class_2561.method_43471((String)"chunk-debug.info.tickets"));
                    for (class_3228 ticket : data.tickets()) {
                        class_5250 type = ChunkSelectionInfo.prettify(ticket.method_14281());
                        class_5250 level = ChunkSelectionInfo.prettify(ticket.method_14283());
                        tickets.add(class_2561.method_43469((String)"chunk-debug.info.tickets.details", (Object[])new Object[]{type, level}));
                    }
                }
                if ((stage = data.stage()) != null) {
                    stages.add(class_2561.method_43469((String)"chunk-debug.info.stage", (Object[])new Object[]{ChunkSelectionInfo.prettify(stage)}));
                }
                unloading.add(class_2561.method_43469((String)"chunk-debug.info.unloading", (Object[])new Object[]{ChunkSelectionInfo.prettify(data.unloading())}));
            } else {
                class_5250 unloaded = class_2561.method_43471((String)"chunk-debug.status.unloaded");
                status.add(class_2561.method_43469((String)"chunk-debug.info.status", (Object[])new Object[]{unloaded}));
            }
        } else {
            class_5250 line;
            title = class_2561.method_43471((String)"chunk-debug.info.breakdown.chunks").method_54663(-932399890);
            class_5250 range = class_2561.method_43473().method_10852((class_2561)ChunkSelectionInfo.prettify(selection.getMinChunkPos())).method_27693(" -> ").method_10852((class_2561)ChunkSelectionInfo.prettify(selection.getMaxChunkPos()));
            location.add(class_2561.method_43469((String)"chunk-debug.info.location", (Object[])new Object[]{range}));
            class_5250 area = class_2561.method_43473().method_10852((class_2561)ChunkSelectionInfo.prettify(selection.sizeX())).method_27693("x").method_10852((class_2561)ChunkSelectionInfo.prettify(selection.sizeZ()));
            location.add(class_2561.method_43469((String)"chunk-debug.info.area", (Object[])new Object[]{area}));
            int lowestLevel = Integer.MAX_VALUE;
            int highestLevel = Integer.MIN_VALUE;
            Object2IntLinkedOpenHashMap statuses = new Object2IntLinkedOpenHashMap();
            Arrays.stream(class_3194.values()).forEachOrdered(s -> statuses.put(s, 0));
            Object2IntOpenHashMap types = new Object2IntOpenHashMap();
            List<ChunkData> selected = selection.stream().mapToObj(arg_0 -> chunks.get(arg_0)).filter(Objects::nonNull).toList();
            for (ChunkData chunk : selected) {
                for (class_3228 ticket : chunk.tickets()) {
                    types.addTo((Object)ticket.method_14281(), 1);
                }
                statuses.addTo((Object)chunk.status(), 1);
                if (chunk.statusLevel() > highestLevel) {
                    highestLevel = chunk.statusLevel();
                }
                if (chunk.statusLevel() >= lowestLevel) continue;
                lowestLevel = chunk.statusLevel();
            }
            status.add(class_2561.method_43469((String)"chunk-debug.info.status.range", (Object[])new Object[]{ChunkSelectionInfo.prettify(lowestLevel), ChunkSelectionInfo.prettify(highestLevel)}));
            tickets.add(class_2561.method_43471((String)"chunk-debug.info.status.distribution"));
            for (Object2IntMap.Entry entry : statuses.object2IntEntrySet()) {
                line = class_2561.method_43473().method_10852((class_2561)ChunkSelectionInfo.prettify((class_3194)entry.getKey()).method_54663(0xFFFFFF)).method_27693(": ").method_10852((class_2561)ChunkSelectionInfo.prettify(entry.getIntValue()));
                tickets.add(line);
            }
            stages.add(class_2561.method_43471((String)"chunk-debug.info.tickets.distribution"));
            for (Object2IntMap.Entry entry : types.object2IntEntrySet()) {
                line = class_2561.method_43473().method_10852((class_2561)ChunkSelectionInfo.prettify((class_3230)entry.getKey()).method_54663(0xFFFFFF)).method_27693(": ").method_10852((class_2561)ChunkSelectionInfo.prettify(entry.getIntValue()));
                stages.add(line);
            }
        }
        return new ChunkSelectionInfo((class_2561)title, List.of(location, status, tickets, stages, unloading));
    }

    private static class_5250 prettify(class_1923 pos) {
        return class_2561.method_43470((String)pos.toString()).method_54663(-932399890);
    }

    private static class_5250 prettify(int statusLevel) {
        return class_2561.method_43470((String)Integer.toString(statusLevel)).method_54663(-932399890);
    }

    private static class_5250 prettify(class_3194 status) {
        return class_2561.method_43471((String)("chunk-debug.status." + status.name().toLowerCase())).method_54663(-932399890);
    }

    private static class_5250 prettify(class_3230 type) {
        String name = ExtraStreamCodecs.getTicketTypeAsString(type);
        return class_2561.method_43471((String)("chunk-debug.ticket.type." + name)).method_54663(-932399890);
    }

    private static class_5250 prettify(class_2806 stage) {
        return class_2561.method_43471((String)("chunk-debug.stage." + stage.method_60550())).method_54663(-932399890);
    }

    private static class_5250 prettify(boolean bool) {
        return class_2561.method_43471((String)("chunk-debug.boolean." + bool)).method_54663(-932399890);
    }
}

