/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.utils;

import me.senseiwells.chunkdebug.client.gui.state.FloatColoredRectangleRenderState;
import me.senseiwells.chunkdebug.client.gui.state.FloatColoredTriangleRenderState;
import me.senseiwells.chunkdebug.client.gui.widget.ArrowButton;
import me.senseiwells.chunkdebug.client.gui.widget.NamedButton;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class RenderUtils {
    public static final int HL_BG_LIGHT = -936035512;
    public static final int HL_BG_DARK = -936561610;
    public static final int BG_LIGHT = 0x55000000;
    public static final int BG_DARK = 0x55000000;
    public static final int HL = -932399890;

    public static void outline(class_332 graphics, float x, float y, float width, float height, float thickness, int color) {
        RenderUtils.fill(graphics, x, y, x + width, y + thickness, color);
        RenderUtils.fill(graphics, x, y + thickness, x + thickness, y + height - thickness, color);
        RenderUtils.fill(graphics, x + width - thickness, y + thickness, x + width, y + height - thickness, color);
        RenderUtils.fill(graphics, x, y + height - thickness, x + width, y + height, color);
    }

    public static void fill(class_332 graphics, float minX, float minY, float maxX, float maxY, int color) {
        class_8030 scissor = graphics.field_44659.method_70863();
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
        FloatColoredRectangleRenderState state = new FloatColoredRectangleRenderState(class_10799.field_56879, class_11231.method_70899(), pose, minX, minY, maxX, maxY, color, color, scissor);
        graphics.field_59826.method_70919((class_11244)state);
    }

    public static void triangle(class_332 graphics, float minX, float minY, float maxX, float maxY, float angle, int color) {
        Matrix3x2fStack pose = graphics.method_51448().pushMatrix();
        class_8030 scissor = graphics.field_44659.method_70863();
        Matrix3x2f copy = pose.rotateAbout(angle * ((float)Math.PI / 180), (minX + maxX) / 2.0f, (minY + maxY) / 2.0f, new Matrix3x2f());
        FloatColoredTriangleRenderState state = new FloatColoredTriangleRenderState(class_10799.field_56879, class_11231.method_70899(), copy, minX, minY, maxX, maxY, color, scissor);
        graphics.field_59826.method_70919((class_11244)state);
        graphics.method_51448().popMatrix();
    }

    public static void options(class_332 graphics, class_327 font, int minX, int maxX, int offsetY, int padding, class_2561 name, ArrowButton left, ArrowButton right) {
        if (left.method_25368() != right.method_25368() || left.method_25364() != right.method_25364()) {
            throw new IllegalArgumentException("Expected buttons to be of the same size");
        }
        int buttonWidth = left.method_25368();
        int buttonHeight = left.method_25364();
        int offsetX = minX + padding;
        int offsetMaxX = maxX - padding - buttonWidth;
        int offsetMaxY = offsetY + buttonHeight;
        left.method_48229(offsetX, offsetY);
        right.method_48229(offsetMaxX, offsetY);
        graphics.method_25294(offsetX += padding + buttonWidth, offsetY, offsetMaxX -= padding, offsetMaxY, 0x55000000);
        NamedButton.renderScrollingString(graphics, font, name, offsetX, offsetY, offsetMaxX, offsetMaxY);
    }

    public static void optionLeft(class_332 graphics, class_327 font, int minX, int maxX, int offsetY, int padding, class_2561 name, class_339 toggle) {
        int buttonWidth = toggle.method_25368();
        int buttonHeight = toggle.method_25364();
        int offsetX = minX + padding;
        int offsetMaxX = maxX - padding;
        int offsetMaxY = offsetY + buttonHeight;
        toggle.method_48229(offsetX, offsetY);
        graphics.method_25294(offsetX += padding + buttonWidth, offsetY, offsetMaxX, offsetMaxY, 0x55000000);
        graphics.method_27535(font, name, offsetX + padding, (offsetY + offsetMaxY - 9) / 2 + 1, -1);
    }

    public static void optionRight(class_332 graphics, class_327 font, int minX, int maxX, int offsetY, int padding, class_2561 name, class_339 toggle) {
        int buttonWidth = toggle.method_25368();
        int buttonHeight = toggle.method_25364();
        int offsetX = minX + padding;
        int offsetMaxX = maxX - buttonWidth - 2 * padding;
        int offsetMaxY = offsetY + buttonHeight;
        graphics.method_25294(offsetX, offsetY, offsetMaxX, offsetMaxY, 0x55000000);
        graphics.method_27535(font, name, offsetX + padding, (offsetY + offsetMaxY - 9) / 2 + 1, -1);
        toggle.method_48229(maxX - buttonWidth - padding, offsetY);
    }

    public static int maxWidth(class_327 font, class_2561 first, class_2561 ... others) {
        int width = font.method_27525((class_5348)first);
        for (class_2561 component : others) {
            width = Math.max(width, font.method_27525((class_5348)component));
        }
        return width;
    }

    public static void setVisible(boolean visible, class_339 ... widgets) {
        for (class_339 widget : widgets) {
            widget.field_22764 = visible;
        }
    }
}

