/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.server.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import me.senseiwells.chunkdebug.ChunkDebug;
import net.fabricmc.loader.api.FabricLoader;

public record ChunkDebugServerConfig(boolean requirePermissions) {
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("chunk-debug-server.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Codec<ChunkDebugServerConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("require_permissions").forGetter(ChunkDebugServerConfig::requirePermissions)).apply((Applicative)instance, ChunkDebugServerConfig::new));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChunkDebugServerConfig read() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            ChunkDebug.LOGGER.info("Generating default server config");
            return ChunkDebugServerConfig.write(new ChunkDebugServerConfig(true));
        }
        try (BufferedReader reader = Files.newBufferedReader(PATH);){
            JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            Optional result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial();
            if (!result.isPresent()) return ChunkDebugServerConfig.write(new ChunkDebugServerConfig(true));
            ChunkDebugServerConfig chunkDebugServerConfig = (ChunkDebugServerConfig)result.get();
            return chunkDebugServerConfig;
        }
        catch (IOException e) {
            ChunkDebug.LOGGER.error("Failed to read chunk-debug-server config", (Throwable)e);
        }
        return ChunkDebugServerConfig.write(new ChunkDebugServerConfig(true));
    }

    private static ChunkDebugServerConfig write(ChunkDebugServerConfig config) {
        block8: {
            try {
                Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
                Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).resultOrPartial();
                if (!result.isPresent()) break block8;
                try (BufferedWriter writer = Files.newBufferedWriter(PATH, new OpenOption[0]);){
                    GSON.toJson((JsonElement)result.get(), (Appendable)writer);
                }
            }
            catch (IOException e) {
                ChunkDebug.LOGGER.error("Failed to write chunk-debug-server config", (Throwable)e);
            }
        }
        return config;
    }
}

