/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client;

import java.util.List;
import java.util.function.Supplier;
import me.senseiwells.chunkdebug.ChunkDebug;
import me.senseiwells.chunkdebug.client.config.ChunkDebugClientConfig;
import me.senseiwells.chunkdebug.client.gui.ChunkDebugMap;
import me.senseiwells.chunkdebug.client.gui.ChunkDebugScreen;
import me.senseiwells.chunkdebug.common.network.ByePayload;
import me.senseiwells.chunkdebug.common.network.ChunkDataPayload;
import me.senseiwells.chunkdebug.common.network.ChunkRefreshPayload;
import me.senseiwells.chunkdebug.common.network.ChunkUnloadPayload;
import me.senseiwells.chunkdebug.common.network.HelloPayload;
import me.senseiwells.chunkdebug.common.network.StartWatchingPayload;
import me.senseiwells.chunkdebug.common.network.StopWatchingPayload;
import me.senseiwells.keybinds.api.InputKeys;
import me.senseiwells.keybinds.api.Keybind;
import me.senseiwells.keybinds.api.KeybindListener;
import me.senseiwells.keybinds.api.KeybindManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.class_9779;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ChunkDebugClient
implements ClientModInitializer {
    private static ChunkDebugClient instance;
    public final ChunkDebugClientConfig config = ChunkDebugClientConfig.read();
    public final Keybind keybind = KeybindManager.register((class_2960)ChunkDebug.id("map"), (InputKeys)InputKeys.of((int[])new int[]{295}));
    @Nullable
    private ChunkDebugMap map;

    public static ChunkDebugClient getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        instance = this;
        this.keybind.setKeys(this.config.chunkDebugMapKeys);
        KeybindManager.addToControlsScreen((class_304.class_11900)class_304.class_11900.field_62556, (Keybind)this.keybind);
        this.keybind.addListener(KeybindListener.onSetKeys(keys -> {
            this.config.chunkDebugMapKeys = keys;
        }));
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::onClientStopping);
        ClientPlayNetworking.registerGlobalReceiver(HelloPayload.TYPE, this::handleHello);
        ClientPlayNetworking.registerGlobalReceiver(ByePayload.TYPE, this::handleBye);
        ClientPlayNetworking.registerGlobalReceiver(ChunkDataPayload.TYPE, this::handleChunkData);
        ClientPlayNetworking.registerGlobalReceiver(ChunkUnloadPayload.TYPE, this::handleChunkUnload);
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.TITLE_AND_SUBTITLE, (class_2960)ChunkDebug.id("minimap"), this::onGuiRender);
    }

    @Nullable
    public ChunkDebugScreen createChunkDebugScreen(@Nullable class_437 parent) {
        if (this.map == null) {
            return null;
        }
        return new ChunkDebugScreen(this.map, parent);
    }

    public void startWatching(class_5321<class_1937> dimension) {
        this.trySendPayload(() -> new StartWatchingPayload(List.of(dimension)));
    }

    public void stopWatching() {
        this.trySendPayload(StopWatchingPayload::new);
    }

    public void refresh() {
        this.trySendPayload(() -> ChunkRefreshPayload.INSTANCE);
    }

    @ApiStatus.Internal
    public void onGuiRender(class_332 graphics, class_9779 tracker) {
        if (this.map != null) {
            this.map.renderMinimap(graphics);
        }
    }

    @ApiStatus.Internal
    public void onGuiResize(int width, int height) {
        if (this.map != null) {
            this.map.resize(width, height);
        }
    }

    private void onClientTick(class_310 minecraft) {
        if (this.map != null) {
            this.map.tick();
        }
        if (this.keybind.consumeClicks() != 0 && minecraft.field_1755 == null) {
            ChunkDebugScreen screen = this.createChunkDebugScreen(null);
            if (screen == null) {
                minecraft.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"chunk-debug.screen.unavailable").method_27692(class_124.field_1061));
            } else {
                minecraft.method_1507((class_437)screen);
            }
        }
    }

    private void onClientStopping(class_310 minecraft) {
        this.setChunkMap(null);
        ChunkDebugClientConfig.write(this.config);
    }

    private void handleHello(HelloPayload payload, ClientPlayNetworking.Context context) {
        if (payload.version() == 4) {
            this.setChunkMap(new ChunkDebugMap(context.client(), this));
            ChunkDebug.LOGGER.info("ChunkDebug connection successful");
        } else if (payload.version() < 4) {
            ChunkDebug.LOGGER.info("ChunkDebug failed to connect, server is out of date!");
        } else {
            ChunkDebug.LOGGER.info("ChunkDebug failed to connect, client is out of date!");
        }
    }

    private void handleBye(ByePayload payload, ClientPlayNetworking.Context context) {
        class_310 minecraft = context.client();
        class_437 class_4372 = minecraft.field_1755;
        if (class_4372 instanceof ChunkDebugScreen) {
            ChunkDebugScreen screen = (ChunkDebugScreen)class_4372;
            screen.method_25419();
        }
        this.setChunkMap(null);
    }

    private void handleChunkData(ChunkDataPayload payload, ClientPlayNetworking.Context context) {
        if (this.map != null) {
            this.map.updateChunks(payload.dimension(), payload.chunks());
        }
    }

    private void handleChunkUnload(ChunkUnloadPayload payload, ClientPlayNetworking.Context context) {
        if (this.map != null) {
            this.map.unloadChunks(payload.dimension(), payload.positions());
        }
    }

    private void trySendPayload(Supplier<class_8710> supplier) {
        class_310 minecraft = class_310.method_1551();
        class_634 listener = minecraft.method_1562();
        if (listener != null) {
            listener.method_52787((class_2596)new class_2817(supplier.get()));
        }
    }

    private void setChunkMap(@Nullable ChunkDebugMap map) {
        if (this.map != null) {
            this.map.close();
        }
        this.map = map;
    }
}

