/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import me.senseiwells.chunkdebug.ChunkDebug;
import me.senseiwells.chunkdebug.client.utils.Corner;
import me.senseiwells.keybinds.api.InputKeys;
import net.fabricmc.loader.api.FabricLoader;

public class ChunkDebugClientConfig {
    public Corner minimapCorner;
    public double minimapOffsetX;
    public double minimapOffsetY;
    public int minimapSize;
    public boolean showStages;
    public boolean showTickets;
    public boolean showMinimap;
    public int chunkRetention;
    public InputKeys chunkDebugMapKeys;
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("chunk-debug-client.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Codec<ChunkDebugClientConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Corner.CODEC.fieldOf("minimap_corner").forGetter(config -> config.minimapCorner), (App)Codec.DOUBLE.fieldOf("minimap_offset_x").forGetter(config -> config.minimapOffsetX), (App)Codec.DOUBLE.fieldOf("minimap_offset_y").forGetter(config -> config.minimapOffsetY), (App)Codec.INT.fieldOf("minimap_size").forGetter(config -> config.minimapSize), (App)Codec.BOOL.fieldOf("show_stages").forGetter(config -> config.showStages), (App)Codec.BOOL.fieldOf("show_tickets").forGetter(config -> config.showTickets), (App)Codec.BOOL.fieldOf("show_minimap").forGetter(config -> config.showMinimap), (App)Codec.INT.fieldOf("chunk_retention").forGetter(config -> config.chunkRetention), (App)InputKeys.CODEC.fieldOf("chunk_debug_map_keys").forGetter(config -> config.chunkDebugMapKeys)).apply((Applicative)instance, ChunkDebugClientConfig::new));

    public ChunkDebugClientConfig(Corner minimapCorner, double minimapOffsetX, double minimapOffsetY, int minimapSize, boolean showStages, boolean showTickets, boolean showMinimap, int chunkRetention, InputKeys chunkDebugMapKeys) {
        this.minimapCorner = minimapCorner;
        this.minimapOffsetX = minimapOffsetX;
        this.minimapOffsetY = minimapOffsetY;
        this.minimapSize = minimapSize;
        this.showStages = showStages;
        this.showTickets = showTickets;
        this.showMinimap = showMinimap;
        this.chunkRetention = chunkRetention;
        this.chunkDebugMapKeys = chunkDebugMapKeys;
    }

    public ChunkDebugClientConfig() {
        this(Corner.TOP_LEFT, 0.0, 0.0, 100, true, true, true, 0, InputKeys.of((int[])new int[]{295}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChunkDebugClientConfig read() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            ChunkDebug.LOGGER.info("Generating default client config");
            return ChunkDebugClientConfig.write(new ChunkDebugClientConfig());
        }
        try (BufferedReader reader = Files.newBufferedReader(PATH);){
            JsonElement element = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            Optional result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial();
            if (!result.isPresent()) return ChunkDebugClientConfig.write(new ChunkDebugClientConfig());
            ChunkDebugClientConfig chunkDebugClientConfig = (ChunkDebugClientConfig)result.get();
            return chunkDebugClientConfig;
        }
        catch (IOException e) {
            ChunkDebug.LOGGER.error("Failed to read chunk-debug-client config", (Throwable)e);
        }
        return ChunkDebugClientConfig.write(new ChunkDebugClientConfig());
    }

    public static ChunkDebugClientConfig write(ChunkDebugClientConfig config) {
        block8: {
            try {
                Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
                Optional result = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).resultOrPartial();
                if (!result.isPresent()) break block8;
                try (BufferedWriter writer = Files.newBufferedWriter(PATH, new OpenOption[0]);){
                    GSON.toJson((JsonElement)result.get(), (Appendable)writer);
                }
            }
            catch (IOException e) {
                ChunkDebug.LOGGER.error("Failed to write chunk-debug-client config", (Throwable)e);
            }
        }
        return config;
    }
}

