/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.senseiwells.chunkdebug.client.ChunkDebugClient;
import me.senseiwells.chunkdebug.client.config.ChunkDebugClientConfig;
import me.senseiwells.chunkdebug.client.gui.ChunkClusters;
import me.senseiwells.chunkdebug.client.gui.ChunkColors;
import me.senseiwells.chunkdebug.client.gui.ChunkSelection;
import me.senseiwells.chunkdebug.client.gui.state.ColoredChunkDataRenderState;
import me.senseiwells.chunkdebug.client.utils.Bounds;
import me.senseiwells.chunkdebug.client.utils.RenderUtils;
import me.senseiwells.chunkdebug.common.utils.ChunkData;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3228;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class ChunkDebugMap {
    private static final int SELECTING_OUTLINE_COLOR = -1431699456;
    private static final int SELECTED_OUTLINE_COLOR = -1426128896;
    private static final int CLUSTER_OUTLINE_COLOR = -932399890;
    private static final int PLAYER_COLOR = -1426063616;
    private static final float MINIMAP_SCALE = 0.5f;
    private final class_310 minecraft;
    private final ChunkDebugClient client;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Map<class_5321<class_1937>, DimensionState> states = new Object2ObjectOpenHashMap();
    private final List<class_5321<class_1937>> dimensions = new ArrayList<class_5321<class_1937>>();
    private ChunkSelection clusterSelection;
    private int clusterTicks = 0;
    private int clusterIndex = 0;
    private int width;
    private int height;
    private int ticks = 0;
    final ChunkDebugClientConfig config;
    Minimap minimap = Minimap.NONE;
    class_1923 center = class_1923.field_35107;
    int dimensionWidth = 0;
    int dimensionIndex = 0;

    public ChunkDebugMap(class_310 minecraft, ChunkDebugClient client) {
        this.minecraft = minecraft;
        this.client = client;
        this.config = client.config;
        this.width = this.minecraft.method_22683().method_4486();
        this.height = this.minecraft.method_22683().method_4502();
    }

    public void updateChunks(class_5321<class_1937> dimension, Collection<ChunkData> chunks) {
        DimensionState state = this.state(dimension);
        for (ChunkData chunk : chunks) {
            state.add(chunk.position().method_8324(), chunk);
        }
    }

    public void unloadChunks(class_5321<class_1937> dimension, long[] positions) {
        DimensionState state = this.state(dimension);
        for (long position : positions) {
            state.remove(position, this.ticks + this.config.chunkRetention);
        }
    }

    public void tick() {
        if (this.clusterTicks > 0) {
            --this.clusterTicks;
        } else {
            this.clusterSelection = null;
        }
        int tick = this.ticks++;
        for (DimensionState state : this.states.values()) {
            state.unloaded.removeAll((Object)tick);
        }
    }

    public void resize(int width, int height) {
        DimensionState state = this.state();
        float oldCenterX = (float)this.width / 2.0f;
        float oldCenterY = (float)this.height / 2.0f;
        float currentX = (oldCenterX - state.offsetX) / state.scale;
        float currentY = (oldCenterY - state.offsetY) / state.scale;
        this.width = width;
        this.height = height;
        float newCenterX = (float)width / 2.0f;
        float newCenterY = (float)height / 2.0f;
        state.offsetX = newCenterX - currentX * state.scale;
        state.offsetY = newCenterY - currentY * state.scale;
        this.updateCenter();
    }

    public void close() {
        this.executor.shutdown();
    }

    public void renderMinimap(class_332 graphics) {
        DimensionState state;
        if (this.minimap == Minimap.NONE || this.minecraft.field_1724 == null) {
            return;
        }
        Bounds bounds = this.getMinimapBounds();
        int minX = bounds.minX();
        int minY = bounds.minY();
        int maxX = bounds.maxX();
        int maxY = bounds.maxY();
        graphics.method_51448().pushMatrix();
        graphics.method_25294(minX - 3, minY - 3, maxX + 3, maxY + 3, -936035512);
        graphics.method_25294(minX, minY, maxX, maxY, -936561610);
        graphics.method_44379(minX, minY, maxX, maxY);
        graphics.method_51448().translate((float)minX + (float)this.config.minimapSize / 2.0f, (float)minY + (float)this.config.minimapSize / 2.0f);
        if (this.minimap == Minimap.STATIC) {
            state = this.state();
            float offsetX = ((float)this.width / 2.0f - state.offsetX) / state.scale;
            float offsetY = ((float)this.height / 2.0f - state.offsetY) / state.scale;
            graphics.method_51448().scale(state.scale * 0.5f, state.scale * 0.5f);
            graphics.method_51448().translate(-offsetX, -offsetY);
        } else {
            class_746 player = this.minecraft.field_1724;
            class_5321 dimension = player.method_73183().method_27983();
            state = this.state((class_5321<class_1937>)dimension);
            class_1923 pos = player.method_31476();
            graphics.method_51448().scale(state.scale * 0.5f, state.scale * 0.5f);
            graphics.method_51448().translate((float)(-pos.field_9181) - 0.5f, (float)(-pos.field_9180) - 0.5f);
        }
        this.renderMap(graphics, state);
        graphics.method_44380();
        graphics.method_51448().popMatrix();
    }

    void renderMap(class_332 graphics, DimensionState state) {
        Int2ObjectOpenHashMap states = new Int2ObjectOpenHashMap();
        for (ChunkData data : state.chunks.values()) {
            class_1923 pos = data.position();
            int color = this.calculateChunkColor(data);
            List positions = (List)states.computeIfAbsent(color, c -> new ObjectArrayList());
            positions.add(pos);
        }
        if (this.config.chunkRetention > 0) {
            for (Map.Entry entry : state.unloaded.entries()) {
                float delta = (float)((Integer)entry.getKey() - this.ticks) / (float)this.config.chunkRetention;
                int alpha = (byte)(delta * 255.0f) << 24 | 0xFFFFFF;
                ChunkData data = (ChunkData)entry.getValue();
                class_1923 pos = data.position();
                int color = this.calculateChunkColor(data) & alpha;
                List positions = (List)states.computeIfAbsent(color, c -> new ObjectArrayList());
                positions.add(pos);
            }
        }
        Matrix3x2f matrix = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
        class_8030 scissor = graphics.field_44659.method_70863();
        ColoredChunkDataRenderState data = new ColoredChunkDataRenderState(class_10799.field_56879, class_11231.method_70899(), matrix, (Int2ObjectMap<List<class_1923>>)states, scissor);
        graphics.field_59826.method_70919((class_11244)data);
        if (state.selection != null) {
            this.renderChunkSelection(graphics, state.selection, -1426128896);
        }
        if (this.minecraft.field_1724 != null && this.minecraft.field_1724.method_73183().method_27983() == state.dimension) {
            this.renderPlayer(graphics, this.minecraft.field_1724.method_31476());
        }
    }

    void renderChunkSelecting(class_332 graphics, double mouseX, double mouseY) {
        DimensionState state = this.state();
        if (state.first != null) {
            ChunkSelection selection = new ChunkSelection(state.first, this.convertScreenToChunkPos(mouseX, mouseY));
            this.renderChunkSelection(graphics, selection, -1431699456);
        }
    }

    void renderChunkClusters(class_332 graphics) {
        if (this.clusterSelection != null) {
            this.renderChunkSelection(graphics, this.clusterSelection, 2.0f, -932399890);
        }
    }

    void incrementDimension(int increment) {
        this.dimensionIndex = (this.dimensionIndex + increment + this.dimensions.size()) % this.dimensions.size();
    }

    void nextMinimap() {
        this.minimap = this.minimap.next();
    }

    void previousMinimap() {
        this.minimap = this.minimap.previous();
    }

    void returnToPlayer() {
        if (this.minecraft.field_1724 != null) {
            this.dimensionIndex = this.dimensions.indexOf(this.minecraft.field_1724.method_73183().method_27983());
            if (this.dimensionIndex != -1) {
                this.setMapCenter(this.minecraft.field_1724.method_31476());
            } else {
                this.dimensionIndex = 0;
            }
        }
    }

    void jumpToCluster(int offset) {
        DimensionState state = this.state();
        state.getCluster(this.clusterIndex + offset).thenApplyAsync(pair -> {
            ChunkSelection selection = (ChunkSelection)pair.first();
            this.clusterIndex = pair.secondInt();
            this.setMapCenter(selection.getCenterChunkPos());
            this.clusterSelection = selection;
            this.clusterTicks = 20;
            return null;
        }, (Executor)this.minecraft);
    }

    void setMapCenterX(int x) {
        this.setMapCenter(x, this.center.field_9180);
    }

    void setMapCenterZ(int z) {
        this.setMapCenter(this.center.field_9181, z);
    }

    void updateCenter() {
        this.center = this.convertScreenToChunkPos((double)this.width / 2.0, (double)this.height / 2.0);
    }

    DimensionState state() {
        return this.state(this.dimension());
    }

    DimensionState state(class_5321<class_1937> dimension) {
        return this.states.computeIfAbsent(dimension, dim -> {
            DimensionState state = new DimensionState((class_5321<class_1937>)dim, this.executor);
            this.initializeState(state);
            return state;
        });
    }

    void resetData() {
        for (DimensionState state : this.states.values()) {
            state.chunks.clear();
            state.unloaded.clear();
            state.clusters.clear();
        }
    }

    void resetStates() {
        this.states.clear();
    }

    class_2561 getMinimapName() {
        return this.minimap.pretty();
    }

    Bounds getMinimapBounds() {
        int padding = 10;
        int minX = this.config.minimapCorner.isLeft() ? padding : this.width - this.config.minimapSize - padding;
        int minY = this.config.minimapCorner.isTop() ? padding : this.height - this.config.minimapSize - padding;
        int maxX = minX + this.config.minimapSize;
        int maxY = minY + this.config.minimapSize;
        return new Bounds(minX, minY, maxX, maxY).offset((int)this.config.minimapOffsetX, (int)this.config.minimapOffsetY);
    }

    class_1923 convertScreenToChunkPos(double x, double y) {
        DimensionState state = this.state();
        double scaledX = (x - (double)state.offsetX) / (double)state.scale;
        double scaledY = (y - (double)state.offsetY) / (double)state.scale;
        return new class_1923(class_3532.method_15357((double)scaledX), class_3532.method_15357((double)scaledY));
    }

    class_5321<class_1937> dimension() {
        if (this.dimensions.isEmpty()) {
            this.loadDimensions();
        }
        return this.dimensions.get(this.dimensionIndex);
    }

    private void renderChunkSelection(class_332 graphics, ChunkSelection selection, int color) {
        this.renderChunkSelection(graphics, selection, 0.4f, color);
    }

    private void renderChunkSelection(class_332 graphics, ChunkSelection selection, float thickness, int color) {
        RenderUtils.outline(graphics, selection.minX, selection.minZ, selection.sizeX(), selection.sizeZ(), thickness, color);
    }

    private void renderPlayer(class_332 graphics, class_1923 pos) {
        RenderUtils.outline(graphics, pos.field_9181, pos.field_9180, 1.0f, 1.0f, 0.3f, -1426063616);
    }

    private boolean isWatching(class_5321<class_1937> dimension) {
        return this.states.containsKey(dimension);
    }

    private void setMapCenter(class_1923 pos) {
        this.setMapCenter(pos.field_9181, pos.field_9180);
    }

    private void setMapCenter(int x, int z) {
        DimensionState state = this.state();
        state.offsetX = (float)this.width / 2.0f - (float)x * state.scale;
        state.offsetY = (float)this.height / 2.0f - (float)z * state.scale;
        this.center = new class_1923(x, z);
    }

    private void initializeState(DimensionState state) {
        if (!this.isWatching(state.dimension)) {
            ChunkDebugClient.getInstance().startWatching(state.dimension);
        }
        if (!state.initialized) {
            class_1923 center = class_1923.field_35107;
            class_746 player = this.minecraft.field_1724;
            if (player != null && player.method_73183().method_27983() == state.dimension) {
                center = player.method_31476();
            }
            state.offsetX = (float)this.width / 2.0f - (float)center.field_9181 * state.scale;
            state.offsetY = (float)this.height / 2.0f - (float)center.field_9180 * state.scale;
            state.initialized = true;
        }
    }

    private void loadDimensions() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_1562() != null) {
            Set dimensions = minecraft.method_1562().method_29356();
            LinkedHashSet<class_5321> sorted = new LinkedHashSet<class_5321>();
            if (dimensions.contains(class_1937.field_25179)) {
                sorted.add(class_1937.field_25179);
            }
            if (dimensions.contains(class_1937.field_25180)) {
                sorted.add(class_1937.field_25180);
            }
            if (dimensions.contains(class_1937.field_25181)) {
                sorted.add(class_1937.field_25181);
            }
            sorted.addAll(dimensions);
            this.dimensions.addAll(sorted);
        } else {
            this.dimensions.add((class_5321<class_1937>)class_1937.field_25179);
            this.dimensions.add((class_5321<class_1937>)class_1937.field_25180);
            this.dimensions.add((class_5321<class_1937>)class_1937.field_25181);
        }
        int width = this.dimensions.stream().mapToInt(key -> minecraft.field_1772.method_1727(key.method_29177().toString())).max().orElse(10);
        this.dimensionWidth = Math.min(width, 140);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            this.dimensionIndex = this.dimensions.indexOf(player.method_73183().method_27983());
        }
    }

    private int calculateChunkColor(ChunkData data) {
        class_1923 pos = data.position();
        class_2806 stage = this.client.config.showStages ? data.stage() : null;
        List<class_3228> tickets = this.client.config.showTickets ? data.tickets() : List.of();
        int color = ChunkColors.calculateChunkColor(data.status(), stage, tickets, data.unloading());
        if ((pos.field_9181 + pos.field_9180) % 2 == 0) {
            color = class_9848.method_61319((float)0.12f, (int)color, (int)0xFFFFFF);
        }
        return color | 0xFF000000;
    }

    public static enum Minimap {
        NONE,
        STATIC,
        FOLLOW;


        public Minimap previous() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> FOLLOW;
                case 1 -> NONE;
                case 2 -> STATIC;
            };
        }

        public Minimap next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> STATIC;
                case 1 -> FOLLOW;
                case 2 -> NONE;
            };
        }

        public class_2561 pretty() {
            return class_2561.method_43471((String)("chunk-debug.settings.minimap." + this.name().toLowerCase()));
        }
    }

    static class DimensionState {
        private final Multimap<Integer, ChunkData> unloaded = HashMultimap.create();
        private final Long2ObjectMap<ChunkData> chunks = new Long2ObjectOpenHashMap();
        private final ChunkClusters clusters = new ChunkClusters();
        private final class_5321<class_1937> dimension;
        private final Executor clusterWorker;
        private boolean initialized = false;
        ChunkSelection selection;
        class_1923 first;
        float scale = 1.0f;
        float offsetX = 0.0f;
        float offsetY = 0.0f;

        private DimensionState(class_5321<class_1937> dimension, Executor clusterWorker) {
            this.dimension = dimension;
            this.clusterWorker = clusterWorker;
        }

        Long2ObjectMap<ChunkData> chunks() {
            return this.chunks;
        }

        private void add(long pos, ChunkData data) {
            this.chunks.put(pos, (Object)data);
            this.clusterWorker.execute(() -> this.clusters.add(pos));
        }

        private void remove(long pos, int tick) {
            this.clusterWorker.execute(() -> this.clusters.remove(pos));
            ChunkData data = (ChunkData)this.chunks.remove(pos);
            if (data != null) {
                this.unloaded.put((Object)tick, (Object)data);
                data.updateUnloading(false);
            }
        }

        private CompletableFuture<ObjectIntPair<ChunkSelection>> getCluster(int index) {
            return CompletableFuture.supplyAsync(() -> {
                int corrected = (index + this.clusters.count()) % this.clusters.count();
                LongSet cluster = this.clusters.getCluster(corrected);
                List<class_1923> positions = cluster.longStream().mapToObj(class_1923::new).toList();
                return ObjectIntPair.of((Object)ChunkSelection.fromPositions(positions), (int)corrected);
            }, this.clusterWorker);
        }
    }
}

