/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.playerparticles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xyz.eclipseisoffline.playerparticles.ParticleSlot;
import xyz.eclipseisoffline.playerparticles.particles.PlayerParticle;

public class ParticleRegistry {
    private static final ParticleRegistry INSTANCE = new ParticleRegistry();
    private final Map<String, PlayerParticle<?>> particles = new HashMap();
    private final Map<ParticleSlot, List<String>> particlesForSlot = new HashMap<ParticleSlot, List<String>>();

    private ParticleRegistry() {
        for (ParticleSlot particleSlot : ParticleSlot.values()) {
            this.particlesForSlot.put(particleSlot, new ArrayList());
        }
    }

    public void register(String particleId, PlayerParticle<?> particle) {
        this.particles.put(particleId, particle);
        for (ParticleSlot particleSlot : ParticleSlot.values()) {
            if (!particle.canWear(particleSlot)) continue;
            this.particlesForSlot.get((Object)particleSlot).add(particleId);
        }
    }

    public String fromParticle(PlayerParticle<?> particle) {
        for (Map.Entry<String, PlayerParticle<?>> particleEntry : this.particles.entrySet()) {
            if (!particleEntry.getValue().equals(particle)) continue;
            return particleEntry.getKey();
        }
        return null;
    }

    public PlayerParticle<?> fromId(String id) {
        return this.particles.get(id);
    }

    public List<String> getRegisteredParticles(ParticleSlot slot) {
        return this.particlesForSlot.get((Object)slot);
    }

    public static ParticleRegistry getInstance() {
        return INSTANCE;
    }
}

