/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.playerparticles;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import xyz.eclipseisoffline.playerparticles.ParticleRegistry;
import xyz.eclipseisoffline.playerparticles.ParticleSlot;
import xyz.eclipseisoffline.playerparticles.PlayerParticleManager;
import xyz.eclipseisoffline.playerparticles.particles.PlayerParticle;
import xyz.eclipseisoffline.playerparticles.particles.data.ParticleDataType;

public class PlayerParticleCommand {
    private static final String PERMISSION = "playerparticles.command";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"playerparticles").requires(source -> source.method_43737() && Permissions.check((class_2172)source, (String)PERMISSION, (int)2));
        for (ParticleSlot particleSlot : ParticleSlot.values()) {
            PlayerParticleCommand.registerParticleSlotCommand(particleSlot, (LiteralArgumentBuilder<class_2168>)command);
        }
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then(class_2170.method_9247((String)"reset").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PlayerParticleManager particleManager = PlayerParticleManager.getInstance(((class_2168)context.getSource()).method_9211());
            for (ParticleSlot slot : ParticleSlot.values()) {
                particleManager.setPlayerParticle(player, slot, null, null);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Reset player particles in all slots"), true);
            return 0;
        }))).then(class_2170.method_9247((String)"off").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PlayerParticleManager particleManager = PlayerParticleManager.getInstance(((class_2168)context.getSource()).method_9211());
            particleManager.setPlayerParticlesEnabled(player, false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Turned player particles off"), true);
            return 0;
        }))).then(class_2170.method_9247((String)"on").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PlayerParticleManager particleManager = PlayerParticleManager.getInstance(((class_2168)context.getSource()).method_9211());
            particleManager.setPlayerParticlesEnabled(player, true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Turned player particles on"), true);
            return 0;
        }))).then(class_2170.method_9247((String)"disable-all").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PlayerParticleManager particleManager = PlayerParticleManager.getInstance(((class_2168)context.getSource()).method_9211());
            particleManager.setAllDisabled(player, true);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Turned all player particles off"), true);
            return 0;
        }))).then(class_2170.method_9247((String)"enable-all").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PlayerParticleManager particleManager = PlayerParticleManager.getInstance(((class_2168)context.getSource()).method_9211());
            particleManager.setAllDisabled(player, false);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Turned all player particles on"), true);
            return 0;
        }));
        dispatcher.register(command);
    }

    private static void registerParticleSlotCommand(ParticleSlot slot, LiteralArgumentBuilder<class_2168> base) {
        base.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)slot.method_15434()).requires(Permissions.require((String)("playerparticles." + slot.method_15434()), (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"particle", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new PlayerParticleSuggestionProvider(slot)).then(class_2170.method_9244((String)"data", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new PlayerParticleDataSuggestionProvider()).executes((Command)new PlayerParticleApplyCommand(slot)))).executes((Command)new PlayerParticleApplyCommand(slot)))).then(class_2170.method_9247((String)"reset").executes((Command)new PlayerParticleApplyCommand(slot, true))));
    }

    private record PlayerParticleSuggestionProvider(ParticleSlot slot) implements SuggestionProvider<class_2168>
    {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
            return class_2172.method_9265(ParticleRegistry.getInstance().getRegisteredParticles(this.slot), (SuggestionsBuilder)builder);
        }
    }

    private static class PlayerParticleDataSuggestionProvider
    implements SuggestionProvider<class_2168> {
        private PlayerParticleDataSuggestionProvider() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            PlayerParticle<?> particle = PlayerParticleApplyCommand.getParticle(context);
            if (particle == null) {
                return builder.buildFuture();
            }
            return particle.particleDataType().getSuggestions(context, builder);
        }
    }

    private static class PlayerParticleApplyCommand
    implements Command<class_2168> {
        private final ParticleSlot slot;
        private final boolean reset;

        private PlayerParticleApplyCommand(ParticleSlot slot) {
            this.slot = slot;
            this.reset = false;
        }

        private PlayerParticleApplyCommand(ParticleSlot slot, boolean reset) {
            this.slot = slot;
            this.reset = reset;
        }

        public int run(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            PlayerParticleManager particleManager = PlayerParticleManager.getInstance(((class_2168)context.getSource()).method_9211());
            if (this.reset) {
                particleManager.setPlayerParticle(player, this.slot, null, null);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Reset particles in slot " + this.slot.method_15434())), true);
                return 0;
            }
            String particleId = StringArgumentType.getString(context, (String)"particle");
            PlayerParticle<?> particle = PlayerParticleApplyCommand.getParticle(context);
            if (particle == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Unknown particle " + particleId))).create();
            }
            if (!particle.canWear(this.slot)) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Cannot wear particle " + particleId + " in slot " + this.slot.method_15434()))).create();
            }
            PlayerParticleApplyCommand.applyPlayerParticle(context, particle, player, this.slot, particleManager);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Applied particle " + particleId + " to slot " + this.slot.method_15434())), true);
            return 0;
        }

        private static <T> void applyPlayerParticle(CommandContext<class_2168> context, PlayerParticle<T> particle, class_3222 player, ParticleSlot slot, PlayerParticleManager particleManager) throws CommandSyntaxException {
            String particleData = PlayerParticleApplyCommand.getParticleData(context);
            ParticleDataType<T> particleDataType = particle.particleDataType();
            class_3902 data = null;
            if (particleData != null) {
                data = (class_3902)particleDataType.parseData(context, particleData);
            } else if (particleDataType == ParticleDataType.EMPTY) {
                data = class_3902.field_17274;
            } else if (particle.particleDataRequired()) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Particle expects data but none was given")).create();
            }
            particleManager.setPlayerParticle(player, slot, particle, data);
        }

        private static PlayerParticle<?> getParticle(CommandContext<class_2168> context) {
            String particleId = StringArgumentType.getString(context, (String)"particle");
            return ParticleRegistry.getInstance().fromId(particleId);
        }

        private static String getParticleData(CommandContext<class_2168> context) {
            try {
                return StringArgumentType.getString(context, (String)"data");
            }
            catch (IllegalArgumentException exception) {
                return null;
            }
        }
    }
}

