/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.playerparticles.particles.data.types;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_9848;
import xyz.eclipseisoffline.playerparticles.particles.data.ParticleDataParser;

public class ColorParticleDataParser
implements ParticleDataParser<List<ColorData>> {
    public static final MapCodec<List<ColorData>> CODEC = ColorData.CODEC.listOf().fieldOf("colors");

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(Collections.singleton("#"), (SuggestionsBuilder)builder);
    }

    @Override
    public List<ColorData> parseData(CommandContext<class_2168> context, String input) throws CommandSyntaxException {
        String[] codes = input.split(" ");
        ArrayList<ColorData> colors = new ArrayList<ColorData>();
        for (String code : codes) {
            if ((code = code.replace("#", "")).length() != 6) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)(code + ": colour must be a 6-digit hexadecimal code"))).create();
            }
            try {
                colors.add(ColorData.fromInt(Integer.valueOf(code, 16)));
            }
            catch (NumberFormatException exception) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)(code + ": invalid hexadecimal code"))).create();
            }
        }
        return colors;
    }

    public record ColorData(float red, float green, float blue) {
        public static final Codec<ColorData> CODEC = Codec.FLOAT.listOf(3, 3).xmap(ColorData::fromList, ColorData::toList);

        public static ColorData fromList(List<Float> floats) {
            if (floats.size() != 3) {
                throw new IllegalArgumentException("Must be exactly 3 floats");
            }
            return new ColorData(floats.get(0).floatValue(), floats.get(1).floatValue(), floats.get(2).floatValue());
        }

        public List<Float> toList() {
            return List.of(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
        }

        public static ColorData fromInt(int color) {
            int red = color >> 16;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            float fRed = (float)red / 255.0f;
            float fGreen = (float)green / 255.0f;
            float fBlue = (float)blue / 255.0f;
            return new ColorData(fRed, fGreen, fBlue);
        }

        public int toInt(float alpha) {
            return class_9848.method_61318((float)alpha, (float)this.red, (float)this.green, (float)this.blue);
        }
    }
}

