/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.playerparticles.particles.simple;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import xyz.eclipseisoffline.playerparticles.ParticleSlot;
import xyz.eclipseisoffline.playerparticles.particles.PlayerParticle;
import xyz.eclipseisoffline.playerparticles.particles.data.ParticleDataType;

public class SimplePlayerParticle
implements PlayerParticle<class_3902> {
    private final SimpleParticleSettings settings;

    public SimplePlayerParticle(class_2394 particle) {
        this(particle, ParticleSlot.values());
    }

    public SimplePlayerParticle(class_2394 particle, ParticleSlot slot, int count, double speed) {
        this(new Builder(particle).withSlot(slot, count, speed));
    }

    public SimplePlayerParticle(class_2394 particle, ParticleSlot ... slots) {
        this(new SimpleParticleSettings(particle, slots));
    }

    public SimplePlayerParticle(Builder builder) {
        this(builder.buildSettings());
    }

    private SimplePlayerParticle(SimpleParticleSettings settings) {
        this.settings = settings;
    }

    @Override
    public void tick(class_3218 level, class_3222 player, ParticleSlot slot, class_3902 data) {
        if (this.settings.interval > 1 && level.method_8503().method_3780() % this.settings.interval != 0) {
            return;
        }
        this.sendParticles(level, player, this.settings.particleOptions, this.defaultParticlePos(player, slot), this.defaultParticleOffset(slot), this.settings.getCount(slot), this.settings.getSpeed(slot));
    }

    @Override
    public boolean canWear(ParticleSlot slot) {
        return this.settings.particleCounts.containsKey((Object)slot);
    }

    @Override
    public ParticleDataType<class_3902> particleDataType() {
        return ParticleDataType.EMPTY;
    }

    public static class Builder {
        private final class_2394 particle;
        private final Map<ParticleSlot, Integer> particleCounts = new HashMap<ParticleSlot, Integer>();
        private final Map<ParticleSlot, Double> particleSpeeds = new HashMap<ParticleSlot, Double>();
        private int interval = 1;

        public Builder(class_2394 particle) {
            this.particle = particle;
        }

        public Builder withSlot(ParticleSlot slot) {
            return this.withSlot(slot, slot.getDefaultCount(), slot.getDefaultSpeed());
        }

        public Builder withSlot(ParticleSlot slot, int count, double speed) {
            if (count < 1 || speed <= 0.0) {
                throw new IllegalArgumentException("Illegal particle count or speed (count below 1 or speed <= 0)");
            }
            this.particleCounts.put(slot, count);
            this.particleSpeeds.put(slot, speed);
            return this;
        }

        public Builder withInterval(int interval) {
            if (interval < 1) {
                throw new IllegalArgumentException("Illegal interval (below 1)");
            }
            this.interval = interval;
            return this;
        }

        public SimplePlayerParticle build() {
            return new SimplePlayerParticle(this.buildSettings());
        }

        private SimpleParticleSettings buildSettings() {
            return new SimpleParticleSettings(this.particle, this.particleCounts, this.particleSpeeds, this.interval);
        }
    }

    private static class SimpleParticleSettings {
        private final class_2394 particleOptions;
        private final Map<ParticleSlot, Integer> particleCounts;
        private final Map<ParticleSlot, Double> particleSpeeds;
        private final int interval;

        private SimpleParticleSettings(class_2394 particle, ParticleSlot ... slots) {
            HashMap<ParticleSlot, Integer> particleCounts = new HashMap<ParticleSlot, Integer>();
            HashMap<ParticleSlot, Double> particleSpeeds = new HashMap<ParticleSlot, Double>();
            for (ParticleSlot slot : slots) {
                particleCounts.put(slot, slot.getDefaultCount());
                particleSpeeds.put(slot, slot.getDefaultSpeed());
            }
            this.particleOptions = particle;
            this.particleCounts = Map.copyOf(particleCounts);
            this.particleSpeeds = Map.copyOf(particleSpeeds);
            this.interval = 1;
        }

        private SimpleParticleSettings(class_2394 particle, Map<ParticleSlot, Integer> particleCounts, Map<ParticleSlot, Double> particleSpeeds, int interval) {
            this.particleOptions = particle;
            this.particleCounts = Map.copyOf(particleCounts);
            this.particleSpeeds = Map.copyOf(particleSpeeds);
            this.interval = interval;
        }

        private int getCount(ParticleSlot slot) {
            return this.particleCounts.get((Object)slot);
        }

        private double getSpeed(ParticleSlot slot) {
            return this.particleSpeeds.get((Object)slot);
        }
    }
}

