/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.playerparticles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import xyz.eclipseisoffline.playerparticles.ParticleSlot;
import xyz.eclipseisoffline.playerparticles.ParticleWithData;
import xyz.eclipseisoffline.playerparticles.particles.PlayerParticle;

public class PlayerParticleManager
extends class_18 {
    public static final Codec<PlayerParticleManager> CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, PlayerParticleOptions.CODEC).xmap(PlayerParticleManager::new, manager -> manager.playerParticles);
    public static final class_10741<PlayerParticleManager> TYPE = new class_10741("playerparticles", PlayerParticleManager::new, CODEC, null);
    private final Map<UUID, PlayerParticleOptions> playerParticles = new HashMap<UUID, PlayerParticleOptions>();

    private PlayerParticleManager(Map<UUID, PlayerParticleOptions> playerParticles) {
        this.playerParticles.putAll(playerParticles);
    }

    private PlayerParticleManager() {
    }

    public static PlayerParticleManager getInstance(MinecraftServer server) {
        return (PlayerParticleManager)server.method_30002().method_17983().method_17924(TYPE);
    }

    public static class_2487 dataFix(class_2487 tag, int dataVersion) {
        class_2487 fixed = new class_2487();
        class_2487 data = (class_2487)tag.method_10562("data").orElseThrow();
        class_2487 fixedData = new class_2487();
        Set uuids = data.method_10541();
        for (String uuid : uuids) {
            class_2487 playerData = data.method_68568(uuid);
            class_2487 fixedPlayerData = new class_2487();
            class_2487 particleData = new class_2487();
            Set slots = playerData.method_10541();
            for (String slotKey : slots) {
                ParticleSlot slot;
                try {
                    slot = ParticleSlot.valueOf(slotKey);
                }
                catch (IllegalArgumentException exception) {
                    continue;
                }
                class_2487 slotTag = (class_2487)playerData.method_10562(slotKey).orElseThrow();
                class_2487 fixedParticle = new class_2487();
                fixedParticle.method_10582("particle", (String)slotTag.method_10558("particle").orElseThrow());
                if (slotTag.method_10545("data")) {
                    class_2487 dataTag = slotTag.method_68568("data");
                    for (String dataKey : dataTag.method_10541()) {
                        fixedParticle.method_10566(dataKey, dataTag.method_10580(dataKey));
                    }
                }
                particleData.method_10566(slot.method_15434(), (class_2520)fixedParticle);
            }
            fixedPlayerData.method_10566("particles", (class_2520)particleData);
            fixedPlayerData.method_10556("enabled", playerData.method_68566("enabled", true));
            fixedPlayerData.method_10556("all_disabled", playerData.method_68566("allDisabled", false));
            fixedData.method_10566(uuid, (class_2520)fixedPlayerData);
        }
        fixed.method_10566("data", (class_2520)fixedData);
        return class_2512.method_48308((class_2487)fixed, (int)dataVersion);
    }

    public void tickPlayerParticles(class_3218 level, class_3222 player) {
        for (ParticleSlot slot : ParticleSlot.values()) {
            ParticleWithData<?> particle = this.getPlayerParticle(player, slot);
            if (particle == null) continue;
            try {
                particle.tick(level, player, slot);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ParticleWithData<?> getPlayerParticle(class_3222 player, ParticleSlot slot) {
        if (this.playerParticles.containsKey(player.method_5667())) {
            PlayerParticleOptions particleOptions = this.playerParticles.get(player.method_5667());
            if (particleOptions.enabled) {
                return particleOptions.getParticle(slot);
            }
        }
        return null;
    }

    public <T> void setPlayerParticle(class_3222 player, ParticleSlot slot, PlayerParticle<T> playerParticle, T data) {
        PlayerParticleOptions playerParticleOptions = this.getOrCreateParticleOptions(player);
        if (playerParticle == null) {
            playerParticleOptions.setParticle(slot, null);
        } else {
            playerParticleOptions.setParticle(slot, new ParticleWithData<T>(playerParticle, data));
        }
        this.method_80();
    }

    public void setPlayerParticlesEnabled(class_3222 player, boolean enabled) {
        PlayerParticleOptions playerParticleOptions = this.getOrCreateParticleOptions(player);
        playerParticleOptions.enabled = enabled;
        this.method_80();
    }

    public boolean hasAllDisabled(class_3222 player) {
        return this.getOrCreateParticleOptions((class_3222)player).allDisabled;
    }

    public void setAllDisabled(class_3222 player, boolean disabled) {
        PlayerParticleOptions playerParticleOptions = this.getOrCreateParticleOptions(player);
        playerParticleOptions.allDisabled = disabled;
        this.method_80();
    }

    private PlayerParticleOptions getOrCreateParticleOptions(class_3222 player) {
        PlayerParticleOptions playerParticleOptions = this.playerParticles.get(player.method_5667());
        if (playerParticleOptions == null) {
            playerParticleOptions = new PlayerParticleOptions();
            this.playerParticles.put(player.method_5667(), playerParticleOptions);
        }
        return playerParticleOptions;
    }

    private static class PlayerParticleOptions {
        private static final Codec<Map<ParticleSlot, ParticleWithData<?>>> PARTICLES_CODEC = Codec.unboundedMap(ParticleSlot.CODEC, ParticleWithData.CODEC);
        private static final Codec<PlayerParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PARTICLES_CODEC.optionalFieldOf("particles", Map.of()).forGetter(options -> options.particles), (App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(options -> options.enabled), (App)Codec.BOOL.optionalFieldOf("all_disabled", (Object)false).forGetter(options -> options.allDisabled)).apply((Applicative)instance, PlayerParticleOptions::new));
        private final Map<ParticleSlot, ParticleWithData<?>> particles = new HashMap();
        private boolean enabled = true;
        private boolean allDisabled = false;

        private PlayerParticleOptions(Map<ParticleSlot, ParticleWithData<?>> particles, boolean enabled, boolean allDisabled) {
            this.particles.putAll(particles);
            this.enabled = enabled;
            this.allDisabled = allDisabled;
        }

        private PlayerParticleOptions() {
        }

        private ParticleWithData<?> getParticle(ParticleSlot slot) {
            return this.particles.get((Object)slot);
        }

        private void setParticle(ParticleSlot slot, ParticleWithData<?> particle) {
            if (particle == null) {
                this.particles.remove((Object)slot);
            } else {
                this.particles.put(slot, particle);
            }
        }
    }
}

