/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.playerparticles;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.eclipseisoffline.playerparticles.ParticleRegistry;
import xyz.eclipseisoffline.playerparticles.PlayerParticleCommand;
import xyz.eclipseisoffline.playerparticles.PlayerParticleManager;
import xyz.eclipseisoffline.playerparticles.particles.PlayerParticles;

public class PlayerParticlesInitializer
implements ModInitializer {
    public static final String MOD_ID = "playerparticles";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"playerparticles");
    private PlayerParticleManager particleManager = null;

    public void onInitialize() {
        Version modVersion = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()).getMetadata().getVersion();
        LOGGER.info("{} version {} initialising", (Object)MOD_ID, (Object)modVersion.getFriendlyString());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> PlayerParticleCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.particleManager = PlayerParticleManager.getInstance(server);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            List players = server.method_3760().method_14571();
            if (this.particleManager == null) {
                return;
            }
            for (class_3222 player : players) {
                if (player.method_5767() || player.method_7325()) continue;
                this.particleManager.tickPlayerParticles(player.method_51469(), player);
            }
        });
        PlayerParticles.registerPlayerParticles(ParticleRegistry.getInstance());
        LOGGER.info("Registered {} player particles", (Object)PlayerParticles.values().length);
    }
}

