/*
 * Decompiled with CFR 0.152.
 */
package xyz.eclipseisoffline.playerparticles.particles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import xyz.eclipseisoffline.playerparticles.ParticleRegistry;
import xyz.eclipseisoffline.playerparticles.ParticleSlot;
import xyz.eclipseisoffline.playerparticles.PlayerParticleManager;
import xyz.eclipseisoffline.playerparticles.particles.data.ParticleDataType;

public interface PlayerParticle<T> {
    public static final Codec<PlayerParticle<?>> CODEC = Codec.STRING.comapFlatMap(string -> {
        PlayerParticle<?> particle = ParticleRegistry.getInstance().fromId((String)string);
        if (particle == null) {
            return DataResult.error(() -> "Unknown player particle " + string);
        }
        return DataResult.success(particle);
    }, particle -> ParticleRegistry.getInstance().fromParticle((PlayerParticle<?>)particle));
    public static final class_243 FLAT_BLOCK_OFFSET = new class_243(0.125, 0.0, 0.125);
    public static final class_243 AROUND_LARGE_OFFSET = new class_243(1.0, 1.0, 1.0);

    public void tick(class_3218 var1, class_3222 var2, ParticleSlot var3, T var4);

    public boolean canWear(ParticleSlot var1);

    default public void sendParticles(class_3218 level, class_3222 source, class_2394 particleOptions, class_243 pos, class_243 offset, int count, double speed) {
        double scale = source.method_45325(class_5134.field_47760);
        if (scale < 1.0) {
            scale = Math.max(1.0, scale + 0.15);
        }
        class_243 scaledOffset = offset.method_18805(scale, scale, scale);
        PlayerParticleManager particleManager = PlayerParticleManager.getInstance(level.method_8503());
        level.method_18766(player -> !particleManager.hasAllDisabled((class_3222)player)).forEach(player -> level.method_14166(player, particleOptions, false, false, pos.field_1352, pos.field_1351, pos.field_1350, count, scaledOffset.field_1352, scaledOffset.field_1351, scaledOffset.field_1350, speed));
    }

    public ParticleDataType<T> particleDataType();

    default public boolean particleDataRequired() {
        return true;
    }

    default public class_243 defaultParticlePos(class_3222 player, ParticleSlot slot) {
        double scale = player.method_45325(class_5134.field_47760);
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case ParticleSlot.ABOVE -> player.method_73189().method_1031(0.0, 2.2 * scale, 0.0);
            case ParticleSlot.BELOW -> player.method_73189().method_1031(0.0, 0.05 * scale, 0.0);
            case ParticleSlot.AROUND -> player.method_73189().method_1031(0.0, scale, 0.0);
        };
    }

    default public class_243 defaultParticleOffset(ParticleSlot slot) {
        if (slot == ParticleSlot.AROUND) {
            return AROUND_LARGE_OFFSET;
        }
        return FLAT_BLOCK_OFFSET;
    }
}

