/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanical_cow.content;

import com.mojang.math.Axis;
import com.oierbravo.mechanical_cow.content.MechanicalCowBlockEntity;
import com.oierbravo.mechanical_cow.registrate.ModPartials;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.DynamicCycleBehavior;
import com.oierbravo.mechanicals.foundation.visual.HalfShaftVisual;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlock;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class MechanicalCowVisual
extends HalfShaftVisual<MechanicalCowBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance cowHead;
    private final RotatingInstance cog;
    private final MechanicalCowBlockEntity mechanicalCowBlockEntity;
    final Direction horizontalDirection;
    private final Direction opposite;

    public MechanicalCowVisual(VisualizationContext context, MechanicalCowBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick, Direction.NORTH);
        this.horizontalDirection = (Direction)this.blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.opposite = this.horizontalDirection.getOpposite();
        this.mechanicalCowBlockEntity = blockEntity;
        this.cowHead = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)ModPartials.HEAD)).createInstance();
        Quaternionf q = Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.getValue(MechanicalPressBlock.HORIZONTAL_FACING)).getOpposite()));
        this.cowHead.rotation((Quaternionfc)q);
        this.cog = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)ModPartials.COG_HORIZONTAL)).createInstance();
        this.cog.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).setChanged();
        this.transformModels(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.transformModels(ctx.partialTick());
    }

    private void transformModels(float pt) {
        this.cog.setup((KineticBlockEntity)this.blockEntity).setChanged();
        float progress = this.getProgress(this.mechanicalCowBlockEntity);
        float yPos = 0.0f;
        if (this.getProgress(this.mechanicalCowBlockEntity) > 0.0f) {
            yPos = (float)Math.sin(progress) / 10.0f;
        }
        this.cowHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, 0.1f + yPos, 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.cog});
        this.relight(this.pos, new FlatLit[]{this.cowHead});
    }

    private float getProgress(MechanicalCowBlockEntity pCowBlockEntity) {
        DynamicCycleBehavior cycleBehavior = pCowBlockEntity.getCycleBehaviour();
        return cycleBehavior.getProgress(AnimationTickHolder.getPartialTicks());
    }

    protected void _delete() {
        super._delete();
        this.cog.delete();
        this.cowHead.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.cog);
        consumer.accept((Instance)this.cowHead);
    }
}

