/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.foliascheduler.util;

import coolcostupit.openjs.foliascheduler.util.ConstructorInvoker;
import coolcostupit.openjs.foliascheduler.util.FieldAccessor;
import coolcostupit.openjs.foliascheduler.util.MethodInvoker;
import coolcostupit.openjs.foliascheduler.util.MinecraftVersions;
import coolcostupit.openjs.foliascheduler.util.ServerVersions;
import coolcostupit.openjs.foliascheduler.util.WrappedReflectiveOperationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.reflectionremapper.ReflectionRemapper;

public final class ReflectionUtil {
    @NotNull
    public static final Predicate<Member> IS_PUBLIC = member -> Modifier.isPublic(member.getModifiers());
    @NotNull
    public static final Predicate<Member> IS_NOT_PUBLIC = IS_PUBLIC.negate();
    @NotNull
    public static final Predicate<Member> IS_PRIVATE = member -> Modifier.isPrivate(member.getModifiers());
    @NotNull
    public static final Predicate<Member> IS_NOT_PRIVATE = IS_PRIVATE.negate();
    @NotNull
    public static final Predicate<Member> IS_STATIC = member -> Modifier.isStatic(member.getModifiers());
    @NotNull
    public static final Predicate<Member> IS_NOT_STATIC = IS_STATIC.negate();
    @NotNull
    public static final Predicate<Member> IS_FINAL = member -> Modifier.isFinal(member.getModifiers());
    @NotNull
    public static final Predicate<Member> IS_NOT_FINAL = IS_FINAL.negate();

    private ReflectionUtil() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    @NotNull
    private static Field makeFieldAccessible(@NotNull Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    @NotNull
    private static Method makeMethodAccessible(@NotNull Method method) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    @NotNull
    public static <T> Class<T> getClass(@NotNull String className) {
        if (ServerVersions.isPaper() && MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
            ReflectionRemapper remapper = ReflectionRemapper.forReobfMappingsInPaperJar();
            className = remapper.remapClassOrArrayName(className);
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new WrappedReflectiveOperationException(e);
        }
    }

    @NotNull
    public static <T> Class<T> getMinecraftClass(@NotNull String packageName, @NotNull String className) {
        if (MinecraftVersions.CAVES_AND_CLIFFS_1.isAtLeast()) {
            return ReflectionUtil.getClass("net.minecraft." + packageName + "." + className);
        }
        return ReflectionUtil.getClass("net.minecraft.server." + MinecraftVersions.getCurrent() + "." + className);
    }

    @NotNull
    public static <T> Class<T> getCraftBukkitClass(@NotNull String classPath) {
        if (ServerVersions.isPaper() && MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
            return ReflectionUtil.getClass("org.bukkit.craftbukkit." + classPath);
        }
        return ReflectionUtil.getClass("org.bukkit.craftbukkit." + MinecraftVersions.getCurrent() + "." + classPath);
    }

    @NotNull
    public static FieldAccessor getField(@NotNull Class<?> clazz, @NotNull String fieldName) {
        try {
            if (ServerVersions.isPaper() && MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
                ReflectionRemapper remapper = ReflectionRemapper.forReobfMappingsInPaperJar();
                fieldName = remapper.remapFieldName(clazz, fieldName);
            }
            return new FieldAccessor(ReflectionUtil.makeFieldAccessible(clazz.getDeclaredField(fieldName)));
        }
        catch (ReflectiveOperationException e) {
            throw new WrappedReflectiveOperationException(e);
        }
    }

    @NotNull
    public static FieldAccessor getField(@NotNull Class<?> clazz, @NotNull Class<?> fieldType) {
        return ReflectionUtil.getField(clazz, fieldType, 0, null);
    }

    @NotNull
    public static FieldAccessor getField(@NotNull Class<?> clazz, @NotNull Class<?> fieldType, int index) {
        return ReflectionUtil.getField(clazz, fieldType, index, null);
    }

    @NotNull
    public static FieldAccessor getField(@NotNull Class<?> clazz, @NotNull Class<?> fieldType, int index, @Nullable Predicate<? super Field> predicate) {
        block4: {
            for (Field field : clazz.getDeclaredFields()) {
                if (!fieldType.isAssignableFrom(field.getType()) || predicate != null && !predicate.test(field) || index-- > 0) continue;
                return new FieldAccessor(ReflectionUtil.makeFieldAccessible(field));
            }
            try {
                if (clazz.getSuperclass() != null) {
                    return ReflectionUtil.getField(clazz.getSuperclass(), fieldType, index, predicate);
                }
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().startsWith("No field of type ")) break block4;
                throw ex;
            }
        }
        throw new IllegalArgumentException("No field of type " + fieldType.getName() + " found in class " + clazz.getName());
    }

    @NotNull
    public static MethodInvoker getMethod(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        try {
            if (ServerVersions.isPaper() && MinecraftVersions.TRAILS_AND_TAILS.get(5).isAtLeast()) {
                ReflectionRemapper remapper = ReflectionRemapper.forReobfMappingsInPaperJar();
                methodName = remapper.remapMethodName(clazz, methodName, new Class[0]);
            }
            return new MethodInvoker(ReflectionUtil.makeMethodAccessible(clazz.getDeclaredMethod(methodName, parameterTypes)));
        }
        catch (ReflectiveOperationException e) {
            throw new WrappedReflectiveOperationException(e);
        }
    }

    @NotNull
    public static MethodInvoker getMethod(@NotNull Class<?> clazz, @NotNull Class<?> returnType, Class<?> ... parameterTypes) {
        return ReflectionUtil.getMethod(clazz, returnType, 0, null, parameterTypes);
    }

    @NotNull
    public static MethodInvoker getMethod(@NotNull Class<?> clazz, @NotNull Class<?> returnType, int index, Class<?> ... parameterTypes) {
        return ReflectionUtil.getMethod(clazz, returnType, index, null, parameterTypes);
    }

    @NotNull
    public static MethodInvoker getMethod(@NotNull Class<?> clazz, @NotNull Class<?> returnType, int index, @Nullable Predicate<? super Method> predicate, Class<?> ... parameterTypes) {
        block5: {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!returnType.isAssignableFrom(method.getReturnType()) || predicate != null && !predicate.test(method) || parameterTypes.length != method.getParameterCount()) continue;
                boolean match = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(method.getParameterTypes()[i])) continue;
                    match = false;
                    break;
                }
                if (!match || index-- > 0) continue;
                return new MethodInvoker(ReflectionUtil.makeMethodAccessible(method));
            }
            try {
                if (clazz.getSuperclass() != null) {
                    return ReflectionUtil.getMethod(clazz.getSuperclass(), returnType, index, predicate, parameterTypes);
                }
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().startsWith("No method with return type ")) break block5;
                throw ex;
            }
        }
        throw new IllegalArgumentException("No method with return type " + returnType.getName() + " found in class " + clazz.getName());
    }

    @NotNull
    public static <T> ConstructorInvoker<T> getConstructor(@NotNull Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(parameterTypes);
            return new ConstructorInvoker<T>(constructor);
        }
        catch (ReflectiveOperationException e) {
            throw new WrappedReflectiveOperationException(e);
        }
    }
}

