/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import coolcostupit.openjs.foliascheduler.FoliaCompatibility;
import coolcostupit.openjs.foliascheduler.ServerImplementation;
import coolcostupit.openjs.foliascheduler.TaskImplementation;
import coolcostupit.openjs.modules.sharedClass;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class FoliaSupport {
    private static Boolean cached = null;
    private static Boolean isFoliaChecked = null;
    private static final Map<Integer, Object> activeTasks = new ConcurrentHashMap<Integer, Object>();
    private static final Map<Integer, TaskType> taskTypes = new ConcurrentHashMap<Integer, TaskType>();
    private static final AtomicInteger nextTaskId = new AtomicInteger(1);
    private static final ExecutorService threadPool;

    public static boolean isFolia() {
        if (cached == null) {
            if (isFoliaChecked == null) {
                boolean foliaDetected = false;
                try {
                    Method getRegionScheduler = Bukkit.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
                    foliaDetected = getRegionScheduler != null;
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
                isFoliaChecked = foliaDetected;
            }
            cached = true;
        }
        return isFoliaChecked;
    }

    public static int ScheduleTask(JavaPlugin plugin, Runnable function, long delay) {
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            TaskImplementation<Void> task = scheduler.async().runDelayed(function, delay);
            return FoliaSupport.addTask(task, TaskType.FOLIA);
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)plugin, function, delay);
        return FoliaSupport.addTask(task, TaskType.BUKKIT);
    }

    public static int runEntityTask(JavaPlugin plugin, Entity entity, Runnable function) {
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            TaskImplementation<Void> foliaTask = scheduler.entity(entity).run(function);
            return FoliaSupport.addTask(foliaTask, TaskType.FOLIA);
        }
        BukkitTask task = Bukkit.getScheduler().runTask((Plugin)plugin, function);
        return FoliaSupport.addTask(task, TaskType.BUKKIT);
    }

    public static int DelayTask(JavaPlugin plugin, Runnable function, long delay) {
        if (FoliaSupport.isFolia()) {
            Future<?> task = threadPool.submit(() -> {
                try {
                    Thread.sleep(delay * 50L);
                    function.run();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            return FoliaSupport.addTask(task, TaskType.THREADPOOL);
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, function, delay);
        return FoliaSupport.addTask(task, TaskType.BUKKIT);
    }

    public static int runTask(JavaPlugin plugin, Runnable function) {
        if (FoliaSupport.isFolia()) {
            Future<?> task = threadPool.submit(function);
            return FoliaSupport.addTask(task, TaskType.THREADPOOL);
        }
        BukkitTask task = Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, function);
        return FoliaSupport.addTask(task, TaskType.BUKKIT);
    }

    public static int runTaskSynchronously(JavaPlugin plugin, Runnable function) {
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            TaskImplementation<Void> task = scheduler.global().run(function);
            return FoliaSupport.addTask(task, TaskType.FOLIA);
        }
        BukkitTask task = Bukkit.getScheduler().runTask((Plugin)plugin, function);
        return FoliaSupport.addTask(task, TaskType.BUKKIT);
    }

    public static int ScheduleRepeatingTask(JavaPlugin plugin, Runnable function, long delay, long period) {
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            TaskImplementation<Void> task = scheduler.async().runAtFixedRate(function, delay, period);
            return FoliaSupport.addTask(task, TaskType.FOLIA);
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, function, delay, period);
        return FoliaSupport.addTask(task, TaskType.BUKKIT);
    }

    public static boolean CancelTask(int taskId) {
        Object task = activeTasks.remove(taskId);
        TaskType type = taskTypes.remove(taskId);
        if (task == null || type == null) {
            return false;
        }
        try {
            switch (type) {
                case FOLIA: {
                    ((TaskImplementation)task).cancel();
                    break;
                }
                case BUKKIT: {
                    ((BukkitTask)task).cancel();
                    break;
                }
                case THREADPOOL: {
                    ((Future)task).cancel(true);
                }
            }
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static int addTask(Object task, TaskType type) {
        int taskId = nextTaskId.getAndIncrement();
        activeTasks.put(taskId, task);
        taskTypes.put(taskId, type);
        return taskId;
    }

    static {
        sharedClass.TaskThreadPool = threadPool = Executors.newCachedThreadPool();
    }

    private static enum TaskType {
        BUKKIT,
        FOLIA,
        THREADPOOL;

    }
}

