/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import coolcostupit.openjs.logging.pluginLogger;
import coolcostupit.openjs.modules.sharedClass;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class LibImporterApi {
    private final Map<String, URLClassLoader> cachedLibs = new ConcurrentHashMap<String, URLClassLoader>();
    private final Path libFolderPath;
    private final pluginLogger Logger = sharedClass.logger;
    private WatchService watchService;
    private Thread watcherThread;

    public LibImporterApi() {
        this.libFolderPath = sharedClass.plugin.getDataFolder().toPath().resolve("Libs");
        this.preLoad();
    }

    public void preLoad() {
        File libFolder = this.libFolderPath.toFile();
        if (!libFolder.exists() && !libFolder.mkdirs()) {
            this.Logger.log(Level.INFO, "Failed to create Libs folder at: " + libFolder.getAbsolutePath(), "\u001b[38;5;214m");
            return;
        }
        this.loadAllLibs();
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.libFolderPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.watcherThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        WatchKey key = this.watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            String fileName = event.context().toString();
                            if (!fileName.toLowerCase().endsWith(".jar")) continue;
                            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                File newJar = this.libFolderPath.resolve(fileName).toFile();
                                this.loadLib(newJar);
                                continue;
                            }
                            if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                            this.unloadLib(fileName);
                        }
                        key.reset();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }, "Libs-Watcher");
            this.watcherThread.setDaemon(true);
            this.watcherThread.start();
        }
        catch (IOException e) {
            this.Logger.log(Level.SEVERE, "Failed to start Libs folder watcher", "\u001b[31m");
        }
    }

    private void loadAllLibs() {
        File[] jars = this.libFolderPath.toFile().listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (jars == null) {
            return;
        }
        for (File jar : jars) {
            this.loadLib(jar);
        }
    }

    public void loadLib(File jarFile) {
        String name = jarFile.getName();
        if (this.cachedLibs.containsKey(name)) {
            this.Logger.log(Level.INFO, "Library already loaded: " + name, "\u001b[38;5;81m");
            return;
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, this.getClass().getClassLoader());
            this.cachedLibs.put(name, loader);
            this.Logger.log(Level.INFO, "Loaded lib: " + name, "\u001b[38;5;81m");
        }
        catch (IOException e) {
            this.Logger.log(Level.SEVERE, "Failed to load lib: " + name + " - " + e.getMessage(), "\u001b[31m");
        }
    }

    public URLClassLoader getLib(String libName) {
        return this.cachedLibs.get(libName.endsWith(".jar") ? libName : libName + ".jar");
    }

    public void unloadLib(String libName) {
        Object fileName = libName.endsWith(".jar") ? libName : libName + ".jar";
        URLClassLoader loader = this.cachedLibs.remove(fileName);
        if (loader != null) {
            try {
                loader.close();
                this.Logger.log(Level.INFO, "Unloaded and removed lib: " + (String)fileName, "\u001b[38;5;49m");
            }
            catch (IOException e) {
                this.Logger.log(Level.WARNING, "Failed to close loader for lib: " + (String)fileName, "\u001b[38;5;214m");
            }
        } else {
            this.Logger.log(Level.WARNING, "Tried to unload non-existent lib: " + (String)fileName, "\u001b[38;5;214m");
        }
    }

    public void shutdown() {
        if (this.watcherThread != null && !this.watcherThread.isInterrupted()) {
            this.watcherThread.interrupt();
        }
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cachedLibs.values().forEach(loader -> {
            try {
                loader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.cachedLibs.clear();
    }
}

