/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import coolcostupit.openjs.modules.sharedClass;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceHolderApiJS {
    private static final Map<String, PlaceholderData> registeredPlaceholders = new HashMap<String, PlaceholderData>();

    public String parseString(Player player, @NotNull String text) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
    }

    public void registerPlaceholder(String prefix, Object handler, String scriptName, ScriptEngine engine) {
        if (registeredPlaceholders.containsKey(prefix)) {
            sharedClass.logger.log(Level.WARNING, "[" + scriptName + "] Placeholder %" + sharedClass.Identifier + "_" + prefix + "% already exists and will be overwritten.", "\u001b[38;5;214m");
        }
        if (prefix.contains("_")) {
            sharedClass.logger.log(Level.WARNING, "[" + scriptName + "] Placeholder '%" + sharedClass.Identifier + "_" + prefix + "%' contains an underscore, which will make it unusable due to parameter splitting!", "\u001b[38;5;214m");
        }
        registeredPlaceholders.put(prefix, new PlaceholderData(handler, engine, scriptName));
        if (sharedClass.configUtil.getConfigFromBuffer("LogPlaceHolderActivity", true).booleanValue()) {
            sharedClass.logger.log(Level.INFO, "[" + scriptName + "] Placeholder %" + sharedClass.Identifier + "_" + prefix + "% has been registered.", "\u001b[38;5;49m");
        }
    }

    public void unregisterPlaceholder(String scriptName) {
        registeredPlaceholders.entrySet().removeIf(entry -> {
            boolean match = ((PlaceholderData)entry.getValue()).scriptName.equals(scriptName);
            if (match && sharedClass.configUtil.getConfigFromBuffer("LogPlaceHolderActivity", true).booleanValue()) {
                sharedClass.logger.log(Level.INFO, "[" + scriptName + "] Placeholder %" + sharedClass.Identifier + "_" + (String)entry.getKey() + "% has been unregistered.", "\u001b[38;5;81m");
            }
            return match;
        });
    }

    public String invokePrefix(String prefix, Player player, String params) {
        PlaceholderData data = registeredPlaceholders.get(prefix);
        if (data == null) {
            return null;
        }
        try {
            return (String)((Invocable)((Object)data.engine)).invokeMethod(data.handler, "onRequest", player, params);
        }
        catch (Exception e) {
            sharedClass.logger.log(Level.SEVERE, "[" + data.scriptName + "] Error invoking placeholder %" + sharedClass.Identifier + "_" + prefix + "% reason: " + e.getMessage(), "\u001b[31m");
            return null;
        }
    }

    public static class PlaceholderData {
        public final Object handler;
        public final ScriptEngine engine;
        public final String scriptName;

        public PlaceholderData(Object handler, ScriptEngine engine, String scriptName) {
            this.handler = handler;
            this.engine = engine;
            this.scriptName = scriptName;
        }
    }
}

