/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PublicVarManager {
    private final Map<String, Object> publicVars = new ConcurrentHashMap<String, Object>();
    private final Lock lock = new ReentrantLock();
    private final Condition varAvailable = this.lock.newCondition();

    public void setPublicVar(String key, Object value) {
        this.lock.lock();
        try {
            this.publicVars.put(key, value);
            this.varAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPublicVar(String key) throws InterruptedException {
        this.lock.lock();
        try {
            long timeout = TimeUnit.MILLISECONDS.toNanos(500L);
            while (!this.publicVars.containsKey(key)) {
                if (timeout <= 0L) {
                    Object var4_3 = null;
                    return var4_3;
                }
                timeout = this.varAvailable.awaitNanos(timeout);
            }
            Object object = this.publicVars.get(key);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }
}

