/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import coolcostupit.openjs.logging.pluginLogger;
import coolcostupit.openjs.modules.FoliaSupport;
import coolcostupit.openjs.modules.scriptWrapper;
import coolcostupit.openjs.modules.sharedClass;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;

public class scriptTaskerApi {
    private final scriptWrapper ScriptWrapper;
    @NotNull
    private final PluginManager pluginManager;
    private final pluginLogger Logger;

    public scriptTaskerApi(scriptWrapper scriptWrapper2) {
        this.ScriptWrapper = scriptWrapper2;
        this.pluginManager = Bukkit.getPluginManager();
        this.Logger = sharedClass.logger;
    }

    public Boolean wait(String scriptName, ScriptEngine scriptEngine, Number seconds) {
        long millis;
        double sec = seconds.doubleValue();
        if (sec <= 0.0) {
            return Boolean.TRUE;
        }
        if (Bukkit.isPrimaryThread()) {
            this.Logger.log(Level.WARNING, "[" + scriptName + "] Calling task.wait(" + sec + "s) on the main server thread can cause lag or freeze the server!", "\u001b[38;5;214m");
        }
        if ((millis = (long)(sec * 1000.0)) < 0L) {
            millis = 0L;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.Logger.log(Level.INFO, "[" + scriptName + "] interrupting task.wait(" + seconds + ")", "\u001b[38;5;81m");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void waitForScript(String scriptName) {
        while (!this.ScriptWrapper.isJavascriptFileRunning(scriptName)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void waitForPlugin(String pluginName, String scriptName) {
        Plugin plugin = this.pluginManager.getPlugin(pluginName);
        if (plugin == null) {
            this.Logger.log(Level.WARNING, "[" + scriptName + "] Plugin \"" + pluginName + "\" does not exist.", "\u001b[38;5;214m");
            return;
        }
        if (plugin.isEnabled()) {
            return;
        }
        while (!plugin.isEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public int spawn(String scriptName, ScriptEngine scriptEngine, Object handler) {
        Runnable task = () -> {
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(handler, "f", new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.Logger.scriptlog(Level.WARNING, scriptName, e.getMessage(), "\u001b[31m");
            }
        };
        int taskId = FoliaSupport.runTask(sharedClass.plugin, task);
        this.ScriptWrapper.scriptTasksMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(taskId);
        return taskId;
    }

    public int entitySchedule(String scriptName, ScriptEngine scriptEngine, Entity entity, Object handler) {
        Runnable task = () -> {
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(handler, "f", new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.Logger.scriptlog(Level.WARNING, scriptName, e.getMessage(), "\u001b[31m");
            }
        };
        int taskId = FoliaSupport.runEntityTask(sharedClass.plugin, entity, task);
        this.ScriptWrapper.scriptTasksMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(taskId);
        return taskId;
    }

    public int main(String scriptName, ScriptEngine scriptEngine, Object handler) {
        Runnable task = () -> {
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(handler, "f", new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.Logger.scriptlog(Level.WARNING, scriptName, e.getMessage(), "\u001b[31m");
            }
        };
        int taskId = FoliaSupport.runTaskSynchronously(sharedClass.plugin, task);
        this.ScriptWrapper.scriptTasksMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(taskId);
        return taskId;
    }

    public int delay(String scriptName, ScriptEngine scriptEngine, Number Delay, Object handler) {
        double sec = Delay.doubleValue();
        if (sec <= 0.0) {
            return 0;
        }
        long ticks = (long)(sec * 20.0);
        Runnable task = () -> {
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(handler, "f", new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.Logger.scriptlog(Level.WARNING, scriptName, e.getMessage(), "\u001b[31m");
            }
        };
        int taskId = FoliaSupport.DelayTask(sharedClass.plugin, task, ticks);
        this.ScriptWrapper.scriptTasksMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(taskId);
        return taskId;
    }

    public int repeat(String scriptName, ScriptEngine scriptEngine, Number Delay, Number Period, Object handler) {
        double delaySec = Delay.doubleValue();
        double periodSec = Period.doubleValue();
        if (delaySec < 0.0) {
            this.Logger.log(Level.WARNING, "[" + scriptName + "] Invalid repeat delay/period values: delay=" + delaySec + ", period=" + periodSec, "\u001b[31m");
            return 0;
        }
        long delayTicks = (long)(delaySec * 20.0);
        long periodTicks = (long)(periodSec * 20.0);
        Runnable task = () -> {
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(handler, "f", new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.Logger.scriptlog(Level.WARNING, scriptName, e.getMessage(), "\u001b[31m");
            }
        };
        int taskId = FoliaSupport.ScheduleRepeatingTask(sharedClass.plugin, task, delayTicks, periodTicks);
        this.ScriptWrapper.scriptTasksMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(taskId);
        return taskId;
    }

    public void cancel(String scriptName, int taskId) {
        List<Integer> taskIds = this.ScriptWrapper.scriptTasksMap.get(scriptName);
        if (taskIds != null && taskIds.remove((Object)taskId)) {
            FoliaSupport.CancelTask(taskId);
            this.Logger.log(Level.INFO, "[" + scriptName + "] Unregistered task ID " + taskId, "\u001b[38;5;81m");
            if (taskIds.isEmpty()) {
                this.ScriptWrapper.scriptTasksMap.remove(scriptName);
            }
        } else {
            this.Logger.log(Level.WARNING, "[" + scriptName + "] Tried to unregister unknown task ID " + taskId, "\u001b[38;5;214m");
        }
    }
}

