/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import coolcostupit.openjs.events.ScriptLoadedEvent;
import coolcostupit.openjs.events.ScriptUnloadedEvent;
import coolcostupit.openjs.logging.ScriptLogger;
import coolcostupit.openjs.logging.pluginLogger;
import coolcostupit.openjs.modules.EventListenerWrapper;
import coolcostupit.openjs.modules.FoliaSupport;
import coolcostupit.openjs.modules.PlaceHolderApiJS;
import coolcostupit.openjs.modules.PublicVarManager;
import coolcostupit.openjs.modules.ScriptEngine;
import coolcostupit.openjs.modules.pApiExtension;
import coolcostupit.openjs.modules.scriptTaskerApi;
import coolcostupit.openjs.modules.sharedClass;
import coolcostupit.openjs.utility.FlagInterpreter;
import coolcostupit.openjs.utility.JavascriptHelper;
import coolcostupit.openjs.utility.VariableStorage;
import coolcostupit.openjs.utility.configurationUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class scriptWrapper {
    private boolean scriptsReady;
    private boolean hasInit;
    private PlaceHolderApiJS placeholderApiJS;
    private final Map<String, List<Listener>> eventListenersMap;
    public final Map<String, List<Integer>> scriptTasksMap;
    private final Map<String, Future<?>> scriptFutures;
    private final Map<String, javax.script.ScriptEngine> scriptEngines;
    private final Map<String, List<Command>> scriptCommands;
    private final JavaPlugin plugin;
    private final File disabledScriptsFile;
    private final pluginLogger Logger;
    private final PublicVarManager PublicVarManager;
    private final configurationUtil configUtil;
    private final VariableStorage variableStorage;
    public final List<String> disabledScripts;
    public final List<String> activeFiles;
    public final List<String> runningScripts;
    public final ExecutorService executorService;
    private final scriptTaskerApi taskApi;

    public scriptWrapper(JavaPlugin plugin, configurationUtil configUtil) {
        boolean scriptsFolderCreated;
        File scriptsFolder;
        block11: {
            this.scriptsReady = false;
            this.hasInit = false;
            this.eventListenersMap = new HashMap<String, List<Listener>>();
            this.scriptTasksMap = new HashMap<String, List<Integer>>();
            this.scriptFutures = new HashMap();
            this.scriptEngines = new HashMap<String, javax.script.ScriptEngine>();
            this.scriptCommands = new HashMap<String, List<Command>>();
            this.disabledScripts = new ArrayList<String>();
            this.activeFiles = new ArrayList<String>();
            this.runningScripts = new ArrayList<String>();
            this.plugin = plugin;
            this.Logger = new pluginLogger(plugin, configUtil);
            this.PublicVarManager = new PublicVarManager();
            this.configUtil = configUtil;
            this.variableStorage = new VariableStorage(plugin);
            this.executorService = Executors.newCachedThreadPool();
            this.taskApi = new scriptTaskerApi(this);
            System.setProperty("nashorn.args", "--language=es6");
            if (sharedClass.IsPapiLoaded.booleanValue()) {
                new pApiExtension().register();
                sharedClass.PlaceHolderApiJavascript = this.placeholderApiJS = new PlaceHolderApiJS();
            }
            if (!this.hasInit) {
                this.hasInit = true;
                FoliaSupport.ScheduleTask(plugin, () -> {
                    this.scriptsReady = true;
                }, 20L);
            }
            scriptsFolder = new File(plugin.getDataFolder(), "scripts");
            scriptsFolderCreated = scriptsFolder.mkdirs();
            this.disabledScriptsFile = new File(plugin.getDataFolder(), "disabledscripts.json");
            if (!this.disabledScriptsFile.exists()) {
                try {
                    boolean fileCreated = this.disabledScriptsFile.createNewFile();
                    if (!fileCreated) break block11;
                    try (FileWriter writer = new FileWriter(this.disabledScriptsFile);){
                        writer.write("[]");
                    }
                }
                catch (IOException e) {
                    this.Logger.log(Level.SEVERE, "Failed to create disabledscripts.json." + e.getMessage(), "\u001b[31m");
                }
            }
        }
        if (!scriptsFolderCreated && !scriptsFolder.exists()) {
            this.Logger.log(Level.WARNING, "Failed to create scripts folder.", "\u001b[38;5;214m");
        }
    }

    public boolean isJavascriptFileActive(String fileName) {
        return this.activeFiles.contains(fileName);
    }

    public boolean isJavascriptFileRunning(String fileName) {
        return this.runningScripts.contains(fileName);
    }

    public List<Listener> getEventListenersFromScript(String scriptName) {
        return this.eventListenersMap.getOrDefault(scriptName, null);
    }

    public void unregisterListener(Listener listener, String scriptName) {
        HandlerList.unregisterAll((Listener)listener);
        List<Listener> listeners = this.eventListenersMap.get(scriptName);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eventListenersMap.remove(scriptName);
            }
        }
    }

    public void unregisterListenersFromScript(String scriptName) {
        List<Listener> activeListeners = this.getEventListenersFromScript(scriptName);
        if (activeListeners != null) {
            ArrayList<Listener> listenersToRemove = new ArrayList<Listener>(activeListeners);
            for (Listener listener : listenersToRemove) {
                this.unregisterListener(listener, scriptName);
            }
        }
    }

    public void unregisterTasksFromScript(String scriptName) {
        List<Integer> taskIds = this.scriptTasksMap.get(scriptName);
        if (taskIds != null) {
            for (int taskId : taskIds) {
                FoliaSupport.CancelTask(taskId);
            }
            this.scriptTasksMap.remove(scriptName);
        }
    }

    public void unloadAllScripts() {
        for (String scriptName : new ArrayList<String>(this.activeFiles)) {
            this.unloadScript(scriptName);
        }
    }

    public void unregisterAllTasks() {
        for (List<Integer> taskIds : this.scriptTasksMap.values()) {
            for (int taskId : taskIds) {
                FoliaSupport.CancelTask(taskId);
            }
        }
        this.scriptTasksMap.clear();
    }

    public void loadDisabledScripts() {
        try (FileReader reader = new FileReader(this.disabledScriptsFile);){
            JSONParser parser = new JSONParser();
            JSONArray jsonArray = (JSONArray)parser.parse((Reader)reader);
            for (Object obj : jsonArray) {
                this.disabledScripts.add((String)obj);
            }
        }
        catch (IOException | ParseException e) {
            this.Logger.log(Level.SEVERE, "Failed to load disabled scripts." + e.getMessage(), "\u001b[31m");
        }
    }

    public void unregisterAllListeners() {
        for (Map.Entry<String, List<Listener>> entry : this.eventListenersMap.entrySet()) {
            List<Listener> listeners = entry.getValue();
            for (Listener listener : listeners) {
                HandlerList.unregisterAll((Listener)listener);
            }
        }
        this.eventListenersMap.clear();
    }

    public CommandMap getCommandMap() {
        CommandMap commandMap = null;
        try {
            Field f = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            this.Logger.log(Level.SEVERE, "Failed to load CommandMap: " + e.getMessage(), "\u001b[31m");
        }
        return commandMap;
    }

    private void removeCommandFromKnownCommands(String commandName) throws Exception {
        CommandMap commandMap = this.getCommandMap();
        Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
        knownCommandsField.setAccessible(true);
        Map knownCommands = (Map)knownCommandsField.get(commandMap);
        knownCommands.remove(commandName);
    }

    private void invokeSyncCommands() {
        try {
            Class<?> serverClass = Bukkit.getServer().getClass();
            Method method = this.getMethod(serverClass, "syncCommands");
            method.setAccessible(true);
            method.invoke((Object)Bukkit.getServer(), new Object[0]);
            method.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.Logger.log(Level.SEVERE, "Failed to sync commands: " + e.getMessage(), "\u001b[31m");
        }
    }

    private Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return this.getMethod(superClass, methodName);
        }
    }

    public void unregisterCommands(String scriptName) {
        List<Command> commands = this.scriptCommands.remove(scriptName);
        if (commands != null) {
            try {
                CommandMap commandMap = this.getCommandMap();
                for (Command dynamicCommand : commands) {
                    this.removeCommandFromKnownCommands(dynamicCommand.getName());
                    boolean Unregistered = dynamicCommand.unregister(commandMap);
                    if (Unregistered) {
                        if (this.configUtil.getConfigFromBuffer("LogCustomCommandsActivity", true).booleanValue()) {
                            this.Logger.log(Level.INFO, "[" + scriptName + "] Unregistered command: " + dynamicCommand.getName(), "\u001b[38;5;49m");
                        }
                        this.invokeSyncCommands();
                        continue;
                    }
                    this.Logger.log(Level.INFO, "[" + scriptName + "] Failed to unregister command: " + dynamicCommand.getName(), "\u001b[38;5;49m");
                }
            }
            catch (Exception e) {
                this.Logger.log(Level.SEVERE, "Failed to unregister commands for script: " + scriptName + " " + e, "\u001b[38;5;214m");
                this.Logger.log(Level.SEVERE, e.getMessage(), "\u001b[31m");
            }
        }
    }

    public void unregisterAllScriptCommands() {
        try {
            for (String scriptName : this.scriptCommands.keySet()) {
                this.unregisterCommands(scriptName);
            }
            this.scriptCommands.clear();
        }
        catch (Exception e) {
            this.Logger.log(Level.SEVERE, "Failed to unregister all script commands.", e.getMessage());
        }
    }

    public void saveDisabledScripts() {
        try (FileWriter writer = new FileWriter(this.disabledScriptsFile);){
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll(this.disabledScripts);
            writer.write(jsonArray.toJSONString());
        }
        catch (IOException e) {
            this.Logger.log(Level.SEVERE, "Failed to save disabled scripts." + e.getMessage(), "\u001b[31m");
        }
    }

    public void checkDisabledScripts() {
        File scriptsFolder = new File(this.plugin.getDataFolder(), "scripts");
        ArrayList<String> scriptsInFolder = new ArrayList<String>();
        if (scriptsFolder.exists() && scriptsFolder.isDirectory()) {
            for (File scriptFile : Objects.requireNonNull(scriptsFolder.listFiles())) {
                if (!scriptFile.isFile() || !scriptFile.getName().endsWith(".js")) continue;
                scriptsInFolder.add(scriptFile.getName());
            }
        }
        boolean modified = false;
        Iterator<String> iterator = this.disabledScripts.iterator();
        while (iterator.hasNext()) {
            String scriptName = iterator.next();
            if (scriptsInFolder.contains(scriptName)) continue;
            iterator.remove();
            modified = true;
            this.Logger.log(Level.INFO, "Removed non-existent script " + scriptName + " from disabled scripts list.", "\u001b[34m");
        }
        if (modified) {
            this.saveDisabledScripts();
        }
    }

    public void unloadScript(String scriptName) {
        Future<?> future;
        if (!this.runningScripts.contains(scriptName)) {
            return;
        }
        this.unregisterListenersFromScript(scriptName);
        this.unregisterCommands(scriptName);
        this.unregisterTasksFromScript(scriptName);
        if (this.placeholderApiJS != null) {
            this.placeholderApiJS.unregisterPlaceholder(scriptName);
        }
        if ((future = this.scriptFutures.remove(scriptName)) != null) {
            future.cancel(true);
        }
        javax.script.ScriptEngine engine = this.scriptEngines.remove(scriptName);
        this.runningScripts.remove(scriptName);
        if (engine != null) {
            if (engine instanceof Invocable) {
                Invocable invocable = (Invocable)((Object)engine);
                try {
                    invocable.invokeFunction("_unloadThis", new Object[0]);
                }
                catch (NoSuchMethodException | ScriptException e) {
                    this.Logger.log(Level.WARNING, "[" + scriptName + "] Failed to garbage collect: " + e.getMessage(), "\u001b[31m");
                }
            }
            engine.getBindings(100).clear();
            engine = null;
        }
        if (this.plugin.isEnabled()) {
            FoliaSupport.runTaskSynchronously(this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new ScriptUnloadedEvent(scriptName)));
        }
    }

    public String preprocessScript(File scriptFile, javax.script.ScriptEngine scriptEngine) throws IOException {
        if (!this.configUtil.getConfigFromBuffer("UseCustomInterpreter", true).booleanValue()) {
            return new String(Files.readAllBytes(scriptFile.toPath()));
        }
        StringBuilder scriptContent = new StringBuilder();
        ArrayList<String> imports = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(scriptFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//!import ")) {
                    String importLine = line.substring(9).trim();
                    imports.add(importLine);
                    continue;
                }
                scriptContent.append(line).append("\n");
            }
        }
        StringBuilder finalScript = new StringBuilder();
        for (String importStatement : imports) {
            try {
                Class<?> clazz = Class.forName(importStatement);
                String simpleName = clazz.getSimpleName();
                scriptEngine.put(simpleName, clazz);
            }
            catch (ClassNotFoundException e) {
                this.Logger.log(Level.WARNING, "Class not found for import: " + importStatement, "\u001b[38;5;214m");
            }
        }
        finalScript.append((CharSequence)scriptContent);
        return finalScript.toString();
    }

    public List<String> getNotLoadedScripts() {
        File scriptsFolder = new File(this.plugin.getDataFolder(), "scripts");
        ArrayList<String> notLoadedScripts = new ArrayList<String>();
        if (scriptsFolder.exists() && scriptsFolder.isDirectory()) {
            for (File scriptFile : Objects.requireNonNull(scriptsFolder.listFiles())) {
                if (!scriptFile.isFile() || !scriptFile.getName().endsWith(".js") || this.activeFiles.contains(scriptFile.getName()) || this.disabledScripts.contains(scriptFile.getName())) continue;
                notLoadedScripts.add(scriptFile.getName());
            }
        }
        return notLoadedScripts;
    }

    public ScriptLoadResult loadScript(File scriptFile, boolean calledFromScript) {
        if (scriptFile.isFile() && scriptFile.getName().endsWith(".js") && !this.disabledScripts.contains(scriptFile.getName())) {
            boolean LoadPapi;
            if (calledFromScript) {
                if (!this.hasInit || !this.scriptsReady) {
                    return new ScriptLoadResult(false, "Do not manually load scripts while they are being initialized!");
                }
            } else if (this.configUtil.getConfigFromBuffer("AllowFeatureFlags", true).booleanValue() && FlagInterpreter.hasFlag(scriptFile, "loadManually")) {
                return new ScriptLoadResult(false, "Script file will only load manually");
            }
            this.unloadScript(scriptFile.getName());
            javax.script.ScriptEngine localScriptEngine = ScriptEngine.getEngine();
            this.scriptEngines.put(scriptFile.getName(), localScriptEngine);
            localScriptEngine.put("plugin", this.plugin);
            localScriptEngine.put("scriptManager", this);
            localScriptEngine.put("scriptEngine", localScriptEngine);
            localScriptEngine.put("currentScriptName", scriptFile.getName());
            localScriptEngine.put("log", new ScriptLogger(Bukkit.getLogger(), scriptFile.getName()));
            localScriptEngine.put("variableStorage", this.variableStorage);
            localScriptEngine.put("DiskStorage", sharedClass.DiskStorageApi);
            localScriptEngine.put("publicVarManager", this.PublicVarManager);
            localScriptEngine.put("_task", this.taskApi);
            localScriptEngine.put("_libImporter", sharedClass.LibImporterApi);
            localScriptEngine.put("IsFoliaServer", FoliaSupport.isFolia());
            if (sharedClass.IsPapiLoaded.booleanValue() && FlagInterpreter.hasFlag(scriptFile, "PlaceholderAPI")) {
                localScriptEngine.put("PlaceholderAPI_", this.placeholderApiJS);
                LoadPapi = true;
            } else {
                LoadPapi = false;
            }
            Future<?> future = this.executorService.submit(() -> {
                try {
                    localScriptEngine.eval("const deepFreeze = function(obj) {\n    if (obj === null || typeof obj !== 'object') return obj;\n    Object.getOwnPropertyNames(obj).forEach(function(name) {\n        var prop = obj[name];\n        if (typeof prop === 'object' && prop !== null && !Object.isFrozen(prop)) {\n            deepFreeze(prop);\n        }\n    });\n    return Object.freeze(obj);\n}\n\ndeepFreeze(plugin);\ndeepFreeze(scriptManager);\ndeepFreeze(scriptEngine);\ndeepFreeze(log);\ndeepFreeze(variableStorage);\ndeepFreeze(DiskStorage);\ndeepFreeze(publicVarManager);\ndeepFreeze(_task);\ndeepFreeze(_libImporter);\n\nObject.defineProperty(this, 'currentScriptName', {\n  value: currentScriptName,\n  writable: false,\n  configurable: false,\n  enumerable: true\n});\n\nObject.defineProperty(this, 'IsFoliaServer', {\n  value: IsFoliaServer,\n  writable: false,\n  configurable: false,\n  enumerable: true\n});\n");
                    if (this.configUtil.getConfigFromBuffer("AllowFeatureFlags", true).booleanValue() && FlagInterpreter.hasFlag(scriptFile, "waitForInit")) {
                        localScriptEngine.eval("scriptManager.waitForInit()");
                    }
                    if (LoadPapi) {
                        localScriptEngine.eval("const PlaceholderAPI = {\n    registerPlaceholder: function(placeholderPrefix, handler) {\n        PlaceholderAPI_.registerPlaceholder(placeholderPrefix, handler, currentScriptName, scriptEngine);\n    },\n    parseString: function(player, text) {\n        return PlaceholderAPI_.parseString(player, text);\n    }\n}\nObject.freeze(PlaceholderAPI);\n");
                    }
                    localScriptEngine.eval(JavascriptHelper.JAVASCRIPT_CODE);
                    String processedScript = this.preprocessScript(scriptFile, localScriptEngine);
                    localScriptEngine.eval(processedScript);
                    if (this.configUtil.getConfigFromBuffer("PrintScriptActivations", true).booleanValue()) {
                        this.Logger.log(Level.INFO, "Loaded the script " + scriptFile.getName(), "\u001b[38;5;49m");
                    }
                    FoliaSupport.runTaskSynchronously(this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new ScriptLoadedEvent(scriptFile.getName())));
                }
                catch (IOException | ScriptException e) {
                    this.Logger.scriptlog(Level.WARNING, scriptFile.getName(), "Failed to load script " + e.getMessage(), "\u001b[38;5;214m");
                }
            });
            if (!this.activeFiles.contains(scriptFile.getName())) {
                this.activeFiles.add(scriptFile.getName());
            }
            if (!this.runningScripts.contains(scriptFile.getName())) {
                this.runningScripts.add(scriptFile.getName());
            }
            this.scriptFutures.put(scriptFile.getName(), future);
            return new ScriptLoadResult(true, "Script loaded successfully.");
        }
        return new ScriptLoadResult(false, "Invalid script file.");
    }

    public void loadScripts() {
        File scriptsFolder = new File(this.plugin.getDataFolder(), "scripts");
        this.unloadAllScripts();
        if (scriptsFolder.exists() && scriptsFolder.isDirectory()) {
            ArrayList<Future<ScriptLoadResult>> futures = new ArrayList<Future<ScriptLoadResult>>();
            for (File scriptFile : Objects.requireNonNull(scriptsFolder.listFiles())) {
                Future<ScriptLoadResult> future = this.executorService.submit(() -> this.loadScript(scriptFile, false));
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    this.Logger.log(Level.WARNING, "An error occurred while waiting for script loading tasks to complete: " + e.getMessage(), "\u001b[38;5;214m");
                }
            }
        }
    }

    public void registerCommand(final String commandName, final Object commandHandler, final String scriptName, final javax.script.ScriptEngine scriptEngine, @Nullable String permission) {
        try {
            CommandMap commandMap = this.getCommandMap();
            Command dynamicCommand = new Command(commandName){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] args) {
                    if (!this.testPermission(sender)) {
                        return true;
                    }
                    try {
                        ((Invocable)((Object)scriptEngine)).invokeMethod(commandHandler, "onCommand", sender, args);
                    }
                    catch (Exception e) {
                        sender.sendMessage("\u00a7cAn error occurred while executing the command: " + e.getMessage());
                        scriptWrapper.this.Logger.log(Level.SEVERE, "Error in script command execution for " + commandName + ": " + e.getMessage(), "\u001b[38;5;214m");
                    }
                    return true;
                }

                @NotNull
                public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
                    if (commandHandler instanceof Bindings && ((Bindings)commandHandler).containsKey("onTabComplete")) {
                        try {
                            return (List)((Invocable)((Object)scriptEngine)).invokeMethod(commandHandler, "onTabComplete", sender, args);
                        }
                        catch (Exception e) {
                            scriptWrapper.this.Logger.log(Level.WARNING, "[" + scriptName + "] Error during tab-completion for command " + commandName + ": " + e.getMessage(), "\u001b[38;5;214m");
                        }
                    }
                    return super.tabComplete(sender, alias, args);
                }
            };
            if (permission != null && !permission.isEmpty()) {
                dynamicCommand.setPermission(permission);
            }
            commandMap.register(this.plugin.getName(), dynamicCommand);
            this.scriptCommands.computeIfAbsent(scriptName, k -> new ArrayList()).add(dynamicCommand);
            this.invokeSyncCommands();
            if (this.configUtil.getConfigFromBuffer("LogCustomCommandsActivity", true).booleanValue()) {
                this.Logger.log(Level.INFO, "[" + scriptName + "] Registered command: " + commandName, "\u001b[38;5;49m");
            }
        }
        catch (Exception e) {
            this.Logger.log(Level.SEVERE, "[" + scriptName + "] Failed to register command " + commandName + ": " + e.getMessage(), "\u001b[31m");
        }
    }

    public void waitForInit() {
        while (!this.scriptsReady) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void registerSchedule(String scriptName, long delay, long period, Object handler, javax.script.ScriptEngine scriptEngine, String methodName) {
        this.Logger.scriptlog(Level.WARNING, scriptName, "Do not use registerSchedule! This will get removed soon, use task.repeat instead!", "\u001b[38;5;214m");
        Runnable task = () -> {
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(handler, methodName, new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.Logger.log(Level.SEVERE, "[" + scriptName + "] " + e.getMessage(), "\u001b[31m");
            }
        };
        int taskId = period > 0L ? FoliaSupport.ScheduleRepeatingTask(this.plugin, task, delay, period) : FoliaSupport.ScheduleTask(this.plugin, task, delay);
        this.scriptTasksMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(taskId);
    }

    public void registerEvent(String eventClassName, Object handler, String scriptName, javax.script.ScriptEngine scriptEngine) {
        try {
            Class<?> eventClass = Class.forName(eventClassName);
            if (Event.class.isAssignableFrom(eventClass)) {
                Class<?> eventClassCasted = eventClass;
                EventListenerWrapper listener = new EventListenerWrapper(scriptEngine, handler, (Plugin)this.plugin);
                Bukkit.getServer().getPluginManager().registerEvent(eventClassCasted, (Listener)listener, EventPriority.NORMAL, (l, e) -> {
                    try {
                        ((Invocable)((Object)scriptEngine)).invokeMethod(handler, "handleEvent", e);
                    }
                    catch (NoSuchMethodException | ScriptException ex) {
                        this.Logger.log(Level.SEVERE, "[" + scriptName + "] " + ex.getMessage(), "\u001b[31m");
                    }
                }, (Plugin)this.plugin);
                this.eventListenersMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(listener);
            } else {
                this.Logger.log(Level.WARNING, "Class " + eventClassName + " is not an Event.", "\u001b[38;5;214m");
            }
        }
        catch (ClassNotFoundException e2) {
            this.Logger.log(Level.WARNING, "Failed to register event " + eventClassName + ": " + e2.getMessage(), "\u001b[38;5;214m");
        }
    }

    public static class ScriptLoadResult {
        private final boolean success;
        private final String message;

        public ScriptLoadResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

