/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.utility;

import coolcostupit.openjs.modules.sharedClass;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class DiskStorage {
    private final File SAVE_DIR;
    private static final Map<String, Map<String, String>> cache = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Set<String> filesBeingSaved = ConcurrentHashMap.newKeySet();

    public DiskStorage(JavaPlugin Plugin2) {
        this.SAVE_DIR = new File(Plugin2.getDataFolder(), "saveFiles");
        if (!this.SAVE_DIR.exists()) {
            this.SAVE_DIR.mkdirs();
        }
    }

    public void saveAllCaches(boolean async) {
        Runnable task = () -> {
            for (String fileName : cache.keySet()) {
                this.saveFile(fileName, false, "", true);
            }
        };
        if (async) {
            new Thread(task).start();
        } else {
            task.run();
        }
    }

    public void loadFile(String fileName, boolean async, String scriptName, boolean global) {
        Runnable task = () -> {
            String fullName = ((String)(global ? fileName : scriptName + "_" + fileName)).replaceAll("[^a-zA-Z0-9._-]", "_");
            File file = new File(this.SAVE_DIR, fullName + ".dat");
            while (filesBeingSaved.contains(fullName)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            HashMap<String, String> fileData = new HashMap<String, String>();
            if (file.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int sepIndex = line.indexOf(61);
                        if (sepIndex <= -1) continue;
                        String key = line.substring(0, sepIndex);
                        String value = line.substring(sepIndex + 1);
                        fileData.put(key, value);
                    }
                }
                catch (IOException e) {
                    sharedClass.logger.log(Level.SEVERE, e.getMessage(), "\u001b[31m");
                }
            }
            cache.put(fullName, fileData);
        };
        if (async) {
            new Thread(task).start();
        } else {
            task.run();
        }
    }

    public void saveFile(String fileName, boolean async, String scriptName, boolean global) {
        Runnable task = () -> {
            String fullName = ((String)(global ? fileName : scriptName + "_" + fileName)).replaceAll("[^a-zA-Z0-9._-]", "_");
            if (!cache.containsKey(fullName)) {
                return;
            }
            if (!filesBeingSaved.add(fullName)) {
                return;
            }
            File file = new File(this.SAVE_DIR, fullName + ".dat");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (Map.Entry<String, String> entry : cache.get(fullName).entrySet()) {
                    writer.write(entry.getKey() + "=" + entry.getValue());
                    writer.newLine();
                }
            }
            catch (IOException e) {
                sharedClass.logger.log(Level.SEVERE, e.getMessage(), "\u001b[31m");
            }
            finally {
                filesBeingSaved.remove(fullName);
                cache.remove(fullName);
            }
        };
        if (async) {
            new Thread(task).start();
        } else {
            task.run();
        }
    }

    public String getValue(String scriptName, boolean global, String fileName, String valueName, String fallbackValue) {
        String fullName = ((String)(global ? fileName : scriptName + "_" + fileName)).replaceAll("[^a-zA-Z0-9._-]", "_");
        Map<String, String> fileCache = cache.get(fullName);
        if (fileCache == null) {
            return fallbackValue;
        }
        return fileCache.getOrDefault(valueName, fallbackValue);
    }

    public void setValue(String scriptName, boolean global, String fileName, String valueName, String value) {
        String fullName = ((String)(global ? fileName : scriptName + "_" + fileName)).replaceAll("[^a-zA-Z0-9._-]", "_");
        cache.computeIfAbsent(fullName, k -> new ConcurrentHashMap()).put(valueName, value);
    }
}

