/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class FlagInterpreter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasFlag(File scriptFile, String flag) {
        try (BufferedReader reader = new BufferedReader(new FileReader(scriptFile));){
            String line;
            int maxLinesToCheck = 5;
            while ((line = reader.readLine()) != null) {
                if (maxLinesToCheck <= 0) return false;
                if (FlagInterpreter.isFlagLine(line, flag)) {
                    boolean bl = true;
                    return bl;
                }
                --maxLinesToCheck;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsFlag(File scriptFile, String flag) {
        try (BufferedReader reader = new BufferedReader(new FileReader(scriptFile));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!FlagInterpreter.isFlagLine(line, flag));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isFlagLine(String line, String flag) {
        return line.trim().equals("//!" + flag);
    }
}

