/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.utility;

import coolcostupit.openjs.logging.pluginLogger;
import coolcostupit.openjs.modules.FoliaSupport;
import coolcostupit.openjs.utility.configurationUtil;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private static final String VERSION_URL = "https://api.spigotmc.org/legacy/update.php?resource=117328";
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final long CHECK_INTERVAL = 12000L;
    private boolean UpdateAvailable;
    private final pluginLogger Logger;
    private final configurationUtil config;
    public String CurrentVersion;
    public String LatestVersion;

    public UpdateChecker(JavaPlugin plugin, pluginLogger Logger2, configurationUtil config) {
        this.plugin = plugin;
        this.Logger = Logger2;
        this.config = config;
    }

    public void startChecking() {
        FoliaSupport.ScheduleRepeatingTask(this.plugin, (Runnable)new BukkitRunnable(){

            public void run() {
                UpdateChecker.this.CheckForUpdates();
            }
        }, 0L, 12000L);
    }

    public void CheckForUpdates() {
        if (this.config.getConfigFromBuffer("UpdateNotifications", true).booleanValue()) {
            this.executorService.submit(() -> {
                String currentVersion = this.plugin.getDescription().getVersion();
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    String latestVersion;
                    HttpGet request = new HttpGet("https://api.spigotmc.org/legacy/update.php?resource=117328t=" + System.currentTimeMillis());
                    CloseableHttpResponse response = httpClient.execute(request);
                    HttpEntity entity = response.getEntity();
                    if (entity != null && this.compareVersions(currentVersion, latestVersion = EntityUtils.toString(entity).trim()) < 0) {
                        this.UpdateAvailable = true;
                        this.CurrentVersion = currentVersion;
                        this.LatestVersion = latestVersion;
                        this.Logger.log(Level.INFO, "A new version of OpenJS is available!", "\u001b[38;5;214m");
                        this.Logger.log(Level.INFO, "Current version: \u001b[31m" + currentVersion, "\u001b[38;5;214m");
                        this.Logger.log(Level.INFO, "Latest version: \u001b[38;5;49m" + latestVersion, "\u001b[38;5;214m");
                        this.Logger.log(Level.INFO, "Download it here: \u001b[38;5;81mhttps://www.spigotmc.org/resources/117328/", "\u001b[38;5;214m");
                    }
                }
                catch (IOException e) {
                    this.Logger.log(Level.SEVERE, "Failed to check for updates: " + e.getMessage(), "\u001b[31m");
                }
            });
        }
    }

    public boolean UpdatesAvailable() {
        return this.UpdateAvailable;
    }

    private int compareVersions(String currentVersion, String latestVersion) {
        String[] currentParts = currentVersion.replaceAll("[^0-9.]", "").split("\\.");
        String[] latestParts = latestVersion.replaceAll("[^0-9.]", "").split("\\.");
        int length = Math.max(currentParts.length, latestParts.length);
        for (int i = 0; i < length; ++i) {
            int latestPart;
            int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
            if (currentPart < latestPart) {
                return -1;
            }
            if (currentPart <= latestPart) continue;
            return 1;
        }
        return 0;
    }
}

