/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.utility;

import coolcostupit.openjs.modules.sharedClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public class VariableStorage {
    private final JavaPlugin plugin;
    private final File storageFile;
    private final Map<String, Object> globalVars;
    private final Map<String, Map<String, Object>> scriptVars;

    public VariableStorage(JavaPlugin plugin) {
        this.plugin = plugin;
        this.storageFile = new File(plugin.getDataFolder(), "variableStorage.dat");
        this.globalVars = new HashMap<String, Object>();
        this.scriptVars = new HashMap<String, Map<String, Object>>();
        this.loadVariables();
    }

    public Object getStoredVar(String scriptName, String varName, Object defaultVar, boolean global) {
        sharedClass.logger.log(Level.WARNING, "[" + scriptName + "] Do not use loadVar(...) use DiskApi instead!", "\u001b[31m");
        if (global) {
            return this.globalVars.computeIfAbsent(varName, k -> defaultVar);
        }
        Map scriptSpecificVars = this.scriptVars.computeIfAbsent(scriptName, k -> new HashMap());
        return scriptSpecificVars.computeIfAbsent(varName, k -> defaultVar);
    }

    public void setStoredVar(String scriptName, String varName, Object var, boolean global) {
        sharedClass.logger.log(Level.WARNING, "[" + scriptName + "] Do not use getVar(...) use DiskApi instead!", "\u001b[31m");
        if (global) {
            this.globalVars.put(varName, var);
        } else {
            Map scriptSpecificVars = this.scriptVars.computeIfAbsent(scriptName, k -> new HashMap());
            scriptSpecificVars.put(varName, var);
        }
    }

    public void saveVariables() {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.storageFile));){
            oos.writeObject(this.globalVars);
            oos.writeObject(this.scriptVars);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save variables: " + e.getMessage());
        }
    }

    private void loadVariables() {
        if (!this.storageFile.exists()) {
            return;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.storageFile));){
            Map loadedGlobalVars = (Map)ois.readObject();
            Map loadedScriptVars = (Map)ois.readObject();
            this.globalVars.putAll(loadedGlobalVars);
            this.scriptVars.putAll(loadedScriptVars);
        }
        catch (IOException | ClassNotFoundException e) {
            this.plugin.getLogger().severe("Failed to load variables: " + e.getMessage());
        }
    }
}

