/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.utility;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class configurationUtil {
    private final JavaPlugin plugin;
    public final Map<String, Object> configBuffer = new HashMap<String, Object>();

    public configurationUtil(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    private void saveConfig() {
        this.plugin.saveConfig();
    }

    public void loadBufferFromConfig() {
        FileConfiguration config = this.getConfig();
        for (String key : config.getKeys(false)) {
            this.configBuffer.put(key, config.get(key));
        }
    }

    public void saveBufferToConfig() {
        FileConfiguration config = this.getConfig();
        for (Map.Entry<String, Object> entry : this.configBuffer.entrySet()) {
            config.set(entry.getKey(), entry.getValue());
        }
        this.saveConfig();
    }

    public <T> T getConfigFromBuffer(String configName, T defaultValue) {
        if (this.configBuffer.containsKey(configName)) {
            Object value = this.configBuffer.get(configName);
            if (defaultValue instanceof Boolean) {
                return (T)Boolean.valueOf(value.toString());
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf(value.toString());
            }
            if (defaultValue instanceof Double) {
                return (T)Double.valueOf(value.toString());
            }
            if (defaultValue instanceof String) {
                return (T)value.toString();
            }
            return (T)value;
        }
        this.setConfigInBuffer(configName, defaultValue);
        return defaultValue;
    }

    public void setConfigInBuffer(String configName, Object value) {
        this.configBuffer.put(configName, value);
    }

    public void reloadConfigBuffer() {
        this.plugin.reloadConfig();
        this.configBuffer.clear();
        this.loadBufferFromConfig();
    }
}

