/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config;

import agency.highlysuspect.quatlib.craftless.config.ConfigOpt;
import agency.highlysuspect.quatlib.craftless.config.SectOrOpt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ConfigSection
implements SectOrOpt {
    private final String name;
    private final List<String> comment;
    private final List<SectOrOpt> children = new ArrayList<SectOrOpt>(4);

    public ConfigSection(String name, List<String> comment) {
        this.name = name;
        this.comment = comment;
    }

    public ConfigSection(String name, String ... comment) {
        this(name, Arrays.asList(comment));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getComment() {
        return this.comment;
    }

    @Nullable
    public SectOrOpt getByName(String name) {
        for (SectOrOpt child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public ConfigSection getSectionByName(String name) {
        ConfigSection section;
        SectOrOpt sectOrOpt = this.getByName(name);
        return sectOrOpt instanceof ConfigSection ? (section = (ConfigSection)sectOrOpt) : null;
    }

    @Nullable
    public ConfigOpt<?> getOptByName(String name) {
        ConfigOpt opt;
        SectOrOpt sectOrOpt = this.getByName(name);
        return sectOrOpt instanceof ConfigOpt ? (opt = (ConfigOpt)sectOrOpt) : null;
    }

    public Collection<SectOrOpt> getChildren() {
        return this.children;
    }

    public void add(SectOrOpt ... opts) {
        this.children.addAll(Arrays.asList(opts));
    }

    public ConfigSection subsection(String name, String ... comment) {
        ConfigSection subsection = this.getSectionByName(name);
        if (subsection == null) {
            subsection = new ConfigSection(name, comment);
            this.add(subsection);
        }
        return subsection;
    }
}

