/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config.sn;

import agency.highlysuspect.quatlib.craftless.config.sn.Sn;
import agency.highlysuspect.quatlib.craftless.config.sn.SnList;
import agency.highlysuspect.quatlib.craftless.config.sn.SnView;
import agency.highlysuspect.quatlib.craftless.facet.Id;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public interface SnCodec<T> {
    public static final SnCodec<String> STR = new SnCodec<String>(){

        @Override
        public Sn<?> write(String thing) {
            return Sn.str(thing);
        }

        @Override
        public String parse(SnView sn, CtxChain ctx) throws ReportedException {
            return sn.asString();
        }
    };
    public static final SnCodec<Boolean> BOOL = new SnCodec<Boolean>(){

        @Override
        public Sn<?> write(Boolean thing) {
            return Sn.str(Boolean.toString(thing));
        }

        @Override
        public Boolean parse(SnView sn, CtxChain ctx) throws ReportedException {
            String s;
            return switch (s = sn.asString().toLowerCase(Locale.ROOT).trim()) {
                case "true" -> true;
                case "false" -> false;
                default -> throw ctx.detail("Expected 'true' or 'false' but got '" + s + "'").reportError();
            };
        }
    };
    public static final SnCodec<Integer> INT = new SnCodec<Integer>(){

        @Override
        public Sn<?> write(Integer thing) {
            return Sn.str(Integer.toString(thing));
        }

        @Override
        public Integer parse(SnView sn, CtxChain ctx) throws ReportedException {
            String s = sn.asString();
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Throwable e) {
                throw ctx.cause(e).detail("Could not parse '" + s + "' as an integer").reportError();
            }
        }
    };
    public static final SnCodec<Id> ID = new SnCodec<Id>(){

        @Override
        public Sn<?> write(Id thing) {
            return Sn.str(thing.toString());
        }

        @Override
        public Id parse(SnView sn, CtxChain ctx) throws ReportedException {
            return Id.parse(sn.asString());
        }
    };

    public Sn<?> write(T var1);

    public T parse(SnView var1, CtxChain var2) throws ReportedException;

    public static <T> SnCodec<List<T>> listOf(final SnCodec<T> c) {
        return new SnCodec<List<T>>(){

            @Override
            public Sn<?> write(List<T> thingList) {
                SnList list = new SnList();
                for (Object thing : thingList) {
                    list.add(c.write(thing));
                }
                return list;
            }

            @Override
            public List<T> parse(SnView sn, CtxChain ctx) throws ReportedException {
                SnView.ListView list = sn.asList();
                ArrayList r = new ArrayList(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    r.add(c.parse(list.get(i), ctx));
                }
                return r;
            }
        };
    }
}

