/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config.sn;

import agency.highlysuspect.quatlib.craftless.config.sn.FlatteningSnWriter;
import agency.highlysuspect.quatlib.craftless.config.sn.Sn;
import agency.highlysuspect.quatlib.craftless.config.sn.SnList;
import agency.highlysuspect.quatlib.craftless.config.sn.SnMap;
import agency.highlysuspect.quatlib.craftless.config.sn.SnWriter;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.FailureLogger;
import agency.highlysuspect.quatlib.craftless.failure.FailureRoot;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import org.jetbrains.annotations.Nullable;

public class SnParser {
    private static final int EOF = Integer.MIN_VALUE;
    private final String s;
    private final Cursor cursor;
    private static final char KV_SPLIT = '=';
    private static final char LINE_COMMENT_CHAR = '%';
    private static final String BARE_STRING_ENDERS = "{}[],\r\n=%";

    public SnParser(String s) {
        this.s = s;
        this.cursor = new Cursor();
    }

    @Nullable
    public SnMap tryParseTopLevel(CtxChain ctx) {
        try {
            return this.parseTopLevel(ctx);
        }
        catch (ReportedException e) {
            return null;
        }
    }

    public SnMap parseTopLevel(CtxChain ctx) throws ReportedException {
        SnMap top = new SnMap();
        while (true) {
            this.cursor.skipWhitespaceAndComments();
            int next = this.cursor.peek();
            if (next == Integer.MIN_VALUE) {
                return top;
            }
            this.parseKvInto(top, ctx);
        }
    }

    public Sn<?> parseValue(CtxChain ctx) throws ReportedException {
        this.cursor.skipWhitespaceAndComments();
        return this.parseValue2(ctx);
    }

    private void parseKvInto(SnMap map, CtxChain ctx) throws ReportedException {
        this.cursor.skipWhitespaceAndComments();
        String key = this.parseKey(ctx);
        ctx = ctx.path(key);
        this.cursor.skipWhitespaceAndComments();
        int next = this.cursor.peek();
        if (next == 61) {
            this.cursor.right();
            this.cursor.skipSameLineWhitespaceAndComments();
            next = this.cursor.peek();
            if (next == 13 || next == 10) {
                map.put(key, Sn.str(""));
            } else {
                map.put(key, this.parseValue2(ctx));
            }
        } else if (next == 123) {
            map.put(key, this.parseMap(ctx));
        } else if (next == 91) {
            map.put(key, this.parseList(ctx));
        } else if (next == Integer.MIN_VALUE) {
            ctx.detail("unexpected end of file").reportWarning();
        } else {
            throw ctx.detail("unexpected character '" + (char)next + "'").reportError();
        }
    }

    private SnMap parseMap(CtxChain ctx) throws ReportedException {
        assert (this.cursor.peek() == 123);
        int blockStartLine = this.cursor.startLine;
        this.cursor.right();
        SnMap map = new SnMap();
        while (true) {
            this.cursor.skipWhitespaceAndComments();
            int next = this.cursor.peek();
            if (next == Integer.MIN_VALUE) {
                ctx.detail("unclosed block starting on line " + blockStartLine).reportWarning();
                return map;
            }
            if (next == 44) {
                this.cursor.right();
                continue;
            }
            if (next == 125) {
                this.cursor.right();
                return map;
            }
            this.parseKvInto(map, ctx);
        }
    }

    private SnList parseList(CtxChain ctx) throws ReportedException {
        assert (this.cursor.peek() == 91);
        int listStartLine = this.cursor.startLine;
        this.cursor.right();
        SnList list = new SnList();
        while (true) {
            this.cursor.skipWhitespaceAndComments();
            int next = this.cursor.peek();
            if (next == Integer.MIN_VALUE) {
                ctx.detail("unclosed list starting on line " + listStartLine).reportWarning();
                return list;
            }
            if (next == 44) {
                this.cursor.right();
                continue;
            }
            if (next == 93) {
                this.cursor.right();
                return list;
            }
            list.add(this.parseValue2(ctx.path("[" + list.size() + "]")));
        }
    }

    private String parseKey(CtxChain ctx) throws ReportedException {
        return this.cursor.peek() == 34 ? this.parseQuotedString(ctx) : this.parseBareString(ctx);
    }

    private Sn<?> parseValue2(CtxChain ctx) throws ReportedException {
        int next = this.cursor.peek();
        if (next == Integer.MIN_VALUE) {
            throw ctx.detail("unexpected end of file while parsing a value, on line " + this.cursor.endLine).reportError();
        }
        if (next == 34) {
            return Sn.str(this.parseQuotedString(ctx));
        }
        if (next == 123) {
            return this.parseMap(ctx);
        }
        if (next == 91) {
            return this.parseList(ctx);
        }
        return Sn.str(this.parseBareString(ctx));
    }

    private String parseBareString(CtxChain ctx) throws ReportedException {
        this.cursor.selectUntil(BARE_STRING_ENDERS);
        String bareStringWithWhitespace = this.cursor.cut();
        if (bareStringWithWhitespace.isEmpty()) {
            int next = this.cursor.peek();
            if (next == Integer.MIN_VALUE) {
                throw ctx.detail("Unexpected end of file at line " + this.cursor.endLine).reportError();
            }
            throw ctx.detail("To use the character '" + (char)next + "' in a string, it must be quoted. Line: " + this.cursor.endLine).reportError();
        }
        return bareStringWithWhitespace.trim();
    }

    private String parseQuotedString(CtxChain ctx) throws ReportedException {
        StringBuilder quotedString;
        block9: {
            assert (this.cursor.peek() == 34);
            this.cursor.right();
            this.cursor.delete();
            ctx = ctx.detail("while parsing a quoted string starting on line " + this.cursor.endLine);
            quotedString = new StringBuilder();
            int startLine = this.cursor.startLine;
            while (true) {
                this.cursor.selectUntil("\\\"\n");
                int next = this.cursor.peek();
                if (next == Integer.MIN_VALUE) {
                    ctx.detail("Unexpected end-of-file. Is the string missing a closing quote?").reportWarning();
                    quotedString.append(this.cursor.cut());
                    break block9;
                }
                if (next == 10) {
                    ctx.detail("Quoted string runs off the end of the line (note: use \\ as a line-continuation character)").reportWarning();
                    quotedString.append(this.cursor.cut());
                    break block9;
                }
                if (next != 92) break;
                quotedString.append(this.cursor.cut());
                this.cursor.right();
                int thingToUnescape = this.cursor.peek();
                this.cursor.right();
                this.cursor.delete();
                switch (thingToUnescape) {
                    case -2147483648: {
                        throw ctx.detail("End-of-file parsing an escape sequence").reportError();
                    }
                    case 110: {
                        quotedString.append('\n');
                    }
                    case 116: {
                        quotedString.append('\t');
                    }
                }
                quotedString.append((char)thingToUnescape);
            }
            quotedString.append(this.cursor.cut());
            this.cursor.right();
        }
        return quotedString.toString();
    }

    public static void main(String ... args) {
        FailureRoot failures = new FailureRoot("SnParser").addListener(new FailureLogger(LogFacade.Sysout.INSTANCE));
        String testFile = "% cool comemnt i've decide on\nkey1 = value1\nkey2\n\t\t= \"value2\"\n\t\tkey3 {\n\t\t\t\tsubkey1 = subval1 % end-of-line comment\n\t\t\t\tsubkey2 = subval2\n\t\t}\n\t\tkey4 = {\n\t\t\t\tsubkey3 = \"subval3\"\n\t\t\t\tsubkey4 = \"subval4 addasd\"\n\t\t\t\tsubkey5 =\n\t\t\t\tsubkey6 = askjdasd\n\t\t}\n\nletter [\n\tMaybe \"these unquoted string rules\" are too lenient?\n\tThis file format is a little bit of a disaster, don't you think.\n\tHaha, anyway, just catching up.\n\t{\n\t  signed = \"Your friend, quat.\"\n\t  date = Jun 24 2025\n\t  enclosed = [heart sticker, postcard, \"an opening bracket [\"\n\t              \"and curly brace {\", smashed M&M candy]\n\t}\n]\n\ncrytyping [\n  how can i hold,,all,, these,,,, commas, ,, ,,, bro,,,,,\n]\n\nhmm [\n  outer[inner]outer[inner again, that's neat]outer\n]\n\ncoolmap { with = keys, on = one, line = ? }\n\nfoo = {\n  bar = \"hello, world\n  list = [\n    item1, item2, item3, {\n      key = \"value\n\n";
        SnMap map = new SnParser(testFile).tryParseTopLevel(failures.context().detail("in MyConfigFile.txt"));
        new FlatteningSnWriter().accept(map, (k, v) -> System.out.println(String.valueOf(k) + "\n\t-> '" + v + "'"));
        System.out.println(new SnWriter().write(map));
    }

    class Cursor {
        int start = 0;
        int end = 0;
        int startLine = 1;
        int endLine = 1;

        Cursor() {
        }

        int peek() {
            if (this.end < SnParser.this.s.length()) {
                return SnParser.this.s.charAt(this.end);
            }
            return Integer.MIN_VALUE;
        }

        void right() {
            if (this.peek() == 10) {
                ++this.endLine;
            }
            ++this.end;
        }

        void delete() {
            this.start = this.end;
            this.startLine = this.endLine;
        }

        String cut() {
            String selection = SnParser.this.s.substring(this.start, this.end);
            this.delete();
            return selection;
        }

        void skipSameLineWhitespaceAndComments() {
            this.selectSameLineWhitespace();
            this.delete();
            if (this.peek() == 37) {
                this.selectUntil("\r\n");
                this.delete();
            }
        }

        void skipWhitespaceAndComments() {
            while (true) {
                this.selectWhitespace();
                this.delete();
                if (this.peek() != 37) break;
                this.selectUntil("\r\n");
                this.delete();
            }
        }

        void selectWhitespace() {
            int next;
            while ((next = this.peek()) != Integer.MIN_VALUE && Character.isWhitespace(next)) {
                this.right();
            }
        }

        void selectSameLineWhitespace() {
            int next;
            while ((next = this.peek()) != Integer.MIN_VALUE && next != 13 && next != 10 && Character.isWhitespace(next)) {
                this.right();
            }
        }

        void selectUntil(String untils) {
            int next;
            while ((next = this.peek()) != Integer.MIN_VALUE && untils.indexOf(next) == -1) {
                this.right();
            }
        }

        public String toString() {
            return "cursor[" + this.start + "," + this.end + "] (lines " + this.startLine + "-" + this.endLine + "), selecting '" + SnParser.this.s.substring(this.start, this.end) + "'";
        }
    }
}

