/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config.sn;

import agency.highlysuspect.quatlib.craftless.config.sn.Sn;
import agency.highlysuspect.quatlib.craftless.config.sn.SnList;
import agency.highlysuspect.quatlib.craftless.config.sn.SnMap;
import agency.highlysuspect.quatlib.craftless.config.sn.SnStr;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SnView {
    public CtxChain ctx();

    public boolean isList();

    public ListView asList() throws ReportedException;

    @Nullable
    public ListView asListOrNull();

    public boolean isString();

    public String asString() throws ReportedException;

    @Nullable
    public String asStringOrNull();

    public boolean isMap();

    public MapView asMap() throws ReportedException;

    @Nullable
    public MapView asMapOrNull();

    default public Optional<ListView> asListOpt() {
        return Optional.ofNullable(this.asListOrNull());
    }

    default public Optional<String> asStringOpt() {
        return Optional.ofNullable(this.asStringOrNull());
    }

    default public Optional<MapView> asMapOpt() {
        return Optional.ofNullable(this.asMapOrNull());
    }

    public static interface ListView
    extends SnView {
        public int size();

        public SnView get(int var1) throws ReportedException;
    }

    public static interface MapView
    extends SnView {
        public int size();

        public Set<String> keySet();

        public boolean containsKey(String var1);

        public SnView get(String var1) throws ReportedException;

        @Nullable
        public SnView getOrNull(String var1);

        default public Optional<SnView> getOrEmpty(String key) {
            return Optional.ofNullable(this.getOrNull(key));
        }
    }

    public static class Impl
    implements SnView,
    ListView,
    MapView {
        @NotNull
        private final Sn<?> sn;
        @NotNull
        private final CtxChain ctx;

        public Impl(@NotNull Sn<?> sn, @NotNull CtxChain ctx) {
            this.sn = Objects.requireNonNull(sn);
            this.ctx = Objects.requireNonNull(ctx);
        }

        private ReportedException expected(Class<? extends Sn<?>> expected) {
            String expectedName = Impl.name(expected);
            String gotName = Impl.name(this.sn);
            return this.ctx.detail("Expected " + expectedName + ", but there was " + gotName).reportError();
        }

        private static String name(Class<?> it) {
            if (it == null) {
                return "nothing";
            }
            if (it == SnList.class) {
                return "a list";
            }
            if (it == SnStr.class) {
                return "a string";
            }
            if (it == SnMap.class) {
                return "a map";
            }
            return it.getSimpleName();
        }

        private static String name(Sn<?> s) {
            return s == null ? "null?" : Impl.name(s.getClass());
        }

        @Override
        public CtxChain ctx() {
            return this.ctx;
        }

        public String toString() {
            return "SnView onto " + Impl.name(this.sn) + " at " + String.valueOf(this.ctx);
        }

        @Override
        public boolean isList() {
            return this.sn instanceof SnList;
        }

        @Override
        public ListView asList() throws ReportedException {
            if (this.sn instanceof SnList) {
                return this;
            }
            throw this.expected(SnList.class);
        }

        @Override
        @Nullable
        public ListView asListOrNull() {
            return this.sn instanceof SnList ? this : null;
        }

        @Override
        public boolean isString() {
            return this.sn instanceof SnStr;
        }

        @Override
        public String asString() throws ReportedException {
            Sn<?> sn = this.sn;
            if (sn instanceof SnStr) {
                SnStr str = (SnStr)sn;
                return str.value();
            }
            throw this.expected(SnStr.class);
        }

        @Override
        @Nullable
        public String asStringOrNull() {
            String string;
            Sn<?> sn = this.sn;
            if (sn instanceof SnStr) {
                SnStr str = (SnStr)sn;
                string = str.value();
            } else {
                string = null;
            }
            return string;
        }

        @Override
        public boolean isMap() {
            return this.sn instanceof SnMap;
        }

        @Override
        public MapView asMap() throws ReportedException {
            if (this.sn instanceof SnMap) {
                return this;
            }
            throw this.expected(SnMap.class);
        }

        @Override
        @Nullable
        public MapView asMapOrNull() {
            return this.sn instanceof SnMap ? this : null;
        }

        private RuntimeException impossible() {
            return new IllegalStateException("Unreachable?! at " + String.valueOf(this));
        }

        @Override
        public int size() {
            Sn<?> sn = this.sn;
            if (sn instanceof SnList) {
                SnList arr = (SnList)sn;
                return arr.size();
            }
            sn = this.sn;
            if (sn instanceof SnMap) {
                SnMap map = (SnMap)sn;
                return map.size();
            }
            throw this.impossible();
        }

        @Override
        public SnView get(int i) throws ReportedException {
            Sn<?> sn = this.sn;
            if (!(sn instanceof SnList)) {
                throw this.impossible();
            }
            SnList arr = (SnList)sn;
            if (i < 0 || i >= arr.size()) {
                throw this.ctx.detail("Index " + i + " out of bounds for range " + arr.size()).reportError();
            }
            return new Impl((Sn)arr.get(i), this.ctx.path("[" + i + "]"));
        }

        @Override
        public Set<String> keySet() {
            Sn<?> sn = this.sn;
            if (!(sn instanceof SnMap)) {
                throw this.impossible();
            }
            SnMap map = (SnMap)sn;
            return map.keySet();
        }

        @Override
        public boolean containsKey(String key) {
            Sn<?> sn = this.sn;
            if (!(sn instanceof SnMap)) {
                throw this.impossible();
            }
            SnMap map = (SnMap)sn;
            return map.containsKey(key);
        }

        @Override
        public SnView get(String key) throws ReportedException {
            Sn<?> sn = this.sn;
            if (!(sn instanceof SnMap)) {
                throw this.impossible();
            }
            SnMap map = (SnMap)sn;
            Sn child = (Sn)map.get(key);
            if (child == null) {
                throw this.ctx.detail("No such key '" + key + "'").reportError();
            }
            return new Impl(child, this.ctx.path(key));
        }

        @Override
        @Nullable
        public SnView getOrNull(String key) {
            Sn<?> sn = this.sn;
            if (!(sn instanceof SnMap)) {
                throw this.impossible();
            }
            SnMap map = (SnMap)sn;
            Sn child = (Sn)map.get(key);
            if (child == null) {
                return null;
            }
            return new Impl(child, this.ctx.path(key));
        }
    }
}

