/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet;

import agency.highlysuspect.quatlib.craftless.facet.FacetBucket;
import agency.highlysuspect.quatlib.craftless.facet.Latch;
import agency.highlysuspect.quatlib.craftless.facet.dgen.DgenHelper;
import agency.highlysuspect.quatlib.craftless.facet.facets.BlockEntityTypeFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.DispenserBehaviorFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.FacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.LangFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.RegFacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.SoundEventFacetBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2357;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public interface Gen {
    public void gen(Ctx var1, Consumer<Gen> var2);

    public static void run(Ctx ctx, Gen ... topLevelGens) {
        List<Gen> gensToRun = Arrays.asList(topLevelGens);
        while (!gensToRun.isEmpty()) {
            ArrayList<Gen> more = new ArrayList<Gen>();
            for (Gen gen : gensToRun) {
                gen.gen(ctx, more::add);
            }
            gensToRun = more;
        }
    }

    public static class Ctx {
        public final List<FacetBuilder> facetBuilders = new ArrayList<FacetBuilder>();
        @Nullable
        public final DgenHelper dgen;

        public Ctx(@Nullable DgenHelper dgen) {
            this.dgen = dgen;
        }

        public void buildFacets(FacetBuilder.BuildCtx ctx, FacetBucket bucket) {
            for (FacetBuilder builder : this.facetBuilders) {
                builder.build(ctx, bucket);
            }
            this.facetBuilders.clear();
        }

        public <T> T getService(Class<T> key) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Unknown service " + key.getName());
        }

        public <T extends FacetBuilder> T add(T facet) {
            this.facetBuilders.add(facet);
            return facet;
        }

        public RegFacetBuilder reg(Latch<?> latch, Supplier<?> thing) {
            return this.add(new RegFacetBuilder(latch, thing));
        }

        public <T extends class_2586> BlockEntityTypeFacetBuilder blockEntity(Latch<class_2591<T>> latch) {
            return this.add(new BlockEntityTypeFacetBuilder(latch));
        }

        public DispenserBehaviorFacetBuilder dispenser(Latch<? extends class_1792> latch) {
            return this.add(new DispenserBehaviorFacetBuilder(latch));
        }

        public DispenserBehaviorFacetBuilder dispenser(Latch<? extends class_1792> latch, class_2357 behavior) {
            return this.dispenser(latch).behavior(behavior);
        }

        public LangFacetBuilder lang(String file) {
            return this.add(new LangFacetBuilder(file));
        }

        public SoundEventFacetBuilder sound(Latch<class_3414> sound) {
            return this.add(new SoundEventFacetBuilder(sound));
        }
    }
}

