/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet.facets;

import agency.highlysuspect.quatlib.craftless.facet.FacetBucket;
import agency.highlysuspect.quatlib.craftless.facet.Id;
import agency.highlysuspect.quatlib.craftless.facet.Idable;
import agency.highlysuspect.quatlib.craftless.facet.TagType;
import agency.highlysuspect.quatlib.craftless.facet.facets.FacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.TagFacet;

public class TagFacetBuilder
implements FacetBuilder {
    public final TagType type;
    public final Id tag;
    public String value;
    boolean optional;

    public TagFacetBuilder(TagType type, Idable tag) {
        this.type = type;
        this.tag = tag.getId();
    }

    public TagFacetBuilder(TagType type, String tag) {
        this(type, Id.parse(tag));
    }

    public static TagFacetBuilder block(Idable tag) {
        return new TagFacetBuilder(TagType.BLOCK, tag);
    }

    public static TagFacetBuilder block(String tag) {
        return new TagFacetBuilder(TagType.BLOCK, tag);
    }

    public static TagFacetBuilder item(Idable tag) {
        return new TagFacetBuilder(TagType.ITEM, tag);
    }

    public static TagFacetBuilder item(String tag) {
        return new TagFacetBuilder(TagType.ITEM, tag);
    }

    public static TagFacetBuilder mineableAxe() {
        return TagFacetBuilder.block(Id.parse("minecraft:mineable/axe"));
    }

    public TagFacetBuilder value(String value) {
        this.value = value;
        return this;
    }

    public TagFacetBuilder value(Idable value) {
        return this.value(value.getId().toString());
    }

    public TagFacetBuilder valueTag(Idable valueTag) {
        return this.value("#" + valueTag.getId().toString());
    }

    public TagFacetBuilder valueTag(String valueTag) {
        return this.value("#" + valueTag);
    }

    public TagFacetBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    public void build(FacetBuilder.BuildCtx ctx, FacetBucket facets) {
        if (ctx.dgen == null) {
            return;
        }
        if (this.type == null) {
            throw new IllegalStateException("null type; " + String.valueOf(this));
        }
        if (this.tag == null) {
            throw new IllegalStateException("null tag;" + String.valueOf(this));
        }
        if (this.value == null) {
            throw new IllegalStateException("null value;" + String.valueOf(this));
        }
        facets.add(new TagFacet(this.type, this.tag, this.value, this.optional));
    }

    public String toString() {
        return "TagFacetBuilder{type=%s, tag=%s, value='%s', optional=%s}".formatted(new Object[]{this.type, this.tag, this.value, this.optional});
    }
}

