/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.failure;

import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.FailureListener;
import agency.highlysuspect.quatlib.craftless.util.LogFacade;
import java.util.ArrayList;

public class FailureLogger
implements FailureListener {
    public final LogFacade log;

    public FailureLogger(LogFacade log) {
        this.log = log;
    }

    @Override
    public void reportWarning(CtxChain warning) {
        this.log.info("Warning:", new Object[0]);
        this.report(warning, this.log::info);
    }

    @Override
    public void reportError(CtxChain error) {
        this.log.warn("Error:", new Object[0]);
        this.report(error, this.log::warn);
    }

    private void report(CtxChain ctx, LogFunc f) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        while (ctx != null) {
            if (ctx instanceof CtxChain.StringLink) {
                CtxChain.StringLink s = (CtxChain.StringLink)ctx;
                f.log(" - {}", s.message);
                ctx = ctx.getParent();
                continue;
            }
            if (ctx instanceof CtxChain.PathLink) {
                CtxChain.PathLink p = (CtxChain.PathLink)ctx;
                ctx = this.logPath(p, f);
                continue;
            }
            if (ctx instanceof CtxChain.ThrowableLink) {
                CtxChain.ThrowableLink t = (CtxChain.ThrowableLink)ctx;
                throwables.add(t.cause);
                f.log(" - '{}: {}' [exception {}]", t.cause.getClass().getSimpleName(), t.cause.getMessage(), throwables.size());
                ctx = ctx.getParent();
                continue;
            }
            f.log(" - {}", ctx.thisSegmentString());
            ctx = ctx.getParent();
        }
        for (int i = 0; i < throwables.size(); ++i) {
            f.log(" ", new Object[0]);
            f.log("=== Exception {} ===", i + 1, throwables.get(i));
        }
    }

    private CtxChain logPath(CtxChain.PathLink pathEnd, LogFunc f) {
        CtxChain ctxChain;
        Object bob = pathEnd.pathSegment;
        CtxChain ctx = pathEnd;
        while ((ctxChain = ctx.getParent()) instanceof CtxChain.PathLink) {
            CtxChain.PathLink path = (CtxChain.PathLink)ctxChain;
            bob = path.pathSegment + "." + (String)bob;
            ctx = ctx.getParent();
        }
        f.log(" - at '{}'", bob);
        return ctx.getParent();
    }

    static interface LogFunc {
        public void log(String var1, Object ... var2);
    }
}

