/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftful.fab.event;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class FabServerTickHandler {
    private final Map<Consumer<MinecraftServer>, BusCompat> compats = new IdentityHashMap<Consumer<MinecraftServer>, BusCompat>();

    public void addTicker(Consumer<MinecraftServer> ticker) {
        BusCompat b = this.compats.computeIfAbsent(ticker, t -> {
            BusCompat fresh = new BusCompat((Consumer<MinecraftServer>)t);
            ServerTickEvents.START_SERVER_TICK.register((Object)fresh);
            return fresh;
        });
        b.active = true;
    }

    public void deactivateTicker(Consumer<MinecraftServer> ticker) {
        BusCompat b = this.compats.get(ticker);
        if (b != null) {
            b.active = false;
        }
    }

    static class BusCompat
    implements ServerTickEvents.StartTick {
        final Consumer<MinecraftServer> action;
        boolean active;

        public BusCompat(Consumer<MinecraftServer> action) {
            this.action = action;
        }

        public void onStartTick(MinecraftServer minecraftServer) {
            if (this.active) {
                this.action.accept(minecraftServer);
            }
        }
    }
}

