/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config.sn;

import agency.highlysuspect.quatlib.craftless.config.sn.SnList;
import agency.highlysuspect.quatlib.craftless.config.sn.SnMap;
import agency.highlysuspect.quatlib.craftless.config.sn.SnStr;
import agency.highlysuspect.quatlib.craftless.config.sn.SnView;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Sn<S extends Sn<S>> {
    public S copy();

    default public SnView view(CtxChain ctx) {
        return new SnView.Impl(this, ctx);
    }

    public static SnStr str(String s) {
        return SnStr.of(s);
    }

    public static SnList list(Object ... contents) {
        if (contents.length == 0) {
            return new SnList();
        }
        SnList arr = new SnList();
        for (Object obj : contents) {
            if (obj instanceof String) {
                String s = (String)obj;
                arr.add(SnStr.of(s));
                continue;
            }
            if (obj instanceof Sn) {
                Sn s = (Sn)obj;
                arr.add(s);
                continue;
            }
            throw new IllegalArgumentException(obj.getClass().getSimpleName());
        }
        return arr;
    }

    public static SnMap map(Object ... contents) {
        if (contents.length == 0) {
            return new SnMap();
        }
        if (contents.length % 2 != 0) {
            throw new IllegalArgumentException("odd number of arguments to SnDsl.obj");
        }
        SnMap obj = new SnMap();
        for (int i = 0; i < contents.length; i += 2) {
            String key = (String)contents[i];
            Object value = contents[i + 1];
            if (value instanceof String) {
                String s = (String)value;
                obj.put(key, SnStr.of(s));
                continue;
            }
            if (value instanceof Sn) {
                Sn s = (Sn)value;
                obj.put(key, s);
                continue;
            }
            throw new IllegalArgumentException(obj.getClass().getSimpleName());
        }
        return obj;
    }
}

