/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config;

import agency.highlysuspect.quatlib.craftless.config.SectOrOpt;
import agency.highlysuspect.quatlib.craftless.config.sn.Sn;
import agency.highlysuspect.quatlib.craftless.config.sn.SnCodec;
import agency.highlysuspect.quatlib.craftless.config.sn.SnView;
import agency.highlysuspect.quatlib.craftless.facet.Id;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConfigOpt<T>
implements SectOrOpt {
    private final String name;
    private final List<String> comment;
    private final T defaultValue;
    private final SnCodec<T> codec;
    private final List<Validator<T>> validators = new ArrayList<Validator<T>>(1);
    private final List<Corrector<T>> correctors = new ArrayList<Corrector<T>>(1);

    public ConfigOpt(String name, T defaultValue, SnCodec<T> codec, List<String> comment) {
        this.name = name;
        this.comment = comment;
        this.defaultValue = defaultValue;
        this.codec = codec;
    }

    public ConfigOpt(String name, T defaultValue, SnCodec<T> codec, String ... comment) {
        this(name, defaultValue, codec, Arrays.asList(comment));
    }

    public Sn<?> write(T thing) {
        return this.codec.write(thing);
    }

    public T parse(SnView sn, CtxChain ctx) throws ReportedException {
        return this.codec.parse(sn, ctx);
    }

    public T correct(T thing, CtxChain ctx) {
        T best = thing;
        for (Corrector<T> corrector : this.correctors) {
            best = corrector.correct(best, ctx);
        }
        return best;
    }

    public ConfigOpt<T> addCorrector(Corrector<T> c) {
        this.correctors.add(c);
        return this;
    }

    public void validate(T thing, CtxChain ctx) throws ReportedException {
        for (Validator<T> validator : this.validators) {
            validator.validate(thing, ctx);
        }
    }

    public ConfigOpt<T> addValidator(Validator<T> v) {
        this.validators.add(v);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getComment() {
        return this.comment;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public static interface Corrector<T> {
        public T correct(T var1, CtxChain var2);
    }

    public static interface Validator<T> {
        public void validate(T var1, CtxChain var2) throws ReportedException;
    }

    public static class IdOpt
    extends ConfigOpt<Id> {
        private boolean ensureMinecraftParse = true;

        public IdOpt(String name, Id defaultValue, String ... comment) {
            super(name, defaultValue, SnCodec.ID, comment);
        }

        public IdOpt ensureMinecraftParse(boolean ensureMinecraftParse) {
            this.ensureMinecraftParse = ensureMinecraftParse;
            return this;
        }

        @Override
        public void validate(Id thing, CtxChain ctx) throws ReportedException {
            super.validate(thing, ctx);
            if (this.ensureMinecraftParse) {
                try {
                    thing.toMinecraft();
                }
                catch (Exception e) {
                    throw ctx.cause(e).detail("Failed to parse " + String.valueOf(thing) + " as a Minecraft ResourceLocation").reportError();
                }
            }
        }
    }

    public static class IntOpt
    extends ConfigOpt<Integer> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public IntOpt(String name, Integer defaultValue, String ... comment) {
            super(name, defaultValue, SnCodec.INT, comment);
            this.addCorrector((thing, ctx) -> {
                if (thing < this.min) {
                    if (this.min == 0) {
                        ctx.detail("Value " + thing + " cannot be negative").reportWarning();
                    } else {
                        ctx.detail("Value " + thing + " cannot be below " + this.min).reportWarning();
                    }
                    return this.min;
                }
                if (thing > this.max) {
                    ctx.detail("Value " + thing + " cannot be above " + this.max).reportWarning();
                    return this.max;
                }
                return thing;
            });
            this.addValidator((thing, ctx) -> {
                if (this.min != Integer.MIN_VALUE && thing < this.min) {
                    if (this.min == 0) {
                        throw ctx.detail("Value " + thing + " cannot be negative").reportError();
                    }
                    throw ctx.detail("Value " + thing + " cannot be below " + this.min).reportError();
                }
                if (this.max != Integer.MAX_VALUE && thing > this.max) {
                    throw ctx.detail("Value " + thing + " cannot be above " + this.max).reportError();
                }
            });
        }

        public IntOpt setMin(int min) {
            this.min = min;
            return this;
        }

        public IntOpt setMax(int max) {
            this.max = max;
            return this;
        }

        @Override
        public List<String> getComment() {
            if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
                return super.getComment();
            }
            ArrayList<String> c = new ArrayList<String>(super.getComment());
            if (this.min != Integer.MIN_VALUE) {
                c.add("Must be at least " + this.min + ".");
            }
            if (this.max != Integer.MAX_VALUE) {
                c.add("Must be at most " + this.max + ".");
            }
            return c;
        }
    }

    public static class BoolOpt
    extends ConfigOpt<Boolean> {
        public BoolOpt(String name, Boolean defaultValue, String ... comment) {
            super(name, defaultValue, SnCodec.BOOL, comment);
        }
    }

    public static class StringOpt
    extends ConfigOpt<String> {
        public StringOpt(String name, String defaultValue, String ... comment) {
            super(name, defaultValue, SnCodec.STR, comment);
        }
    }
}

