/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.config;

import agency.highlysuspect.quatlib.craftless.config.ConfigOpt;
import agency.highlysuspect.quatlib.craftless.config.ConfigSection;
import agency.highlysuspect.quatlib.craftless.config.SectOrOpt;
import agency.highlysuspect.quatlib.craftless.config.ValidatedConfig;
import agency.highlysuspect.quatlib.craftless.config.sn.SnView;
import agency.highlysuspect.quatlib.craftless.failure.CtxChain;
import agency.highlysuspect.quatlib.craftless.failure.ReportedException;
import java.util.IdentityHashMap;
import java.util.Map;

public class MatchedUnparsedConfig
extends IdentityHashMap<ConfigOpt<?>, SnView> {
    public MatchedUnparsedConfig(ConfigSection schema, SnView view) {
        this.matchImpl(schema, view);
    }

    private void matchImpl(SectOrOpt item, SnView view) {
        if (view == null) {
            return;
        }
        if (item instanceof ConfigSection) {
            ConfigSection section = (ConfigSection)item;
            SnView.MapView map = view.asMapOrNull();
            if (map == null) {
                return;
            }
            for (SectOrOpt child : section.getChildren()) {
                SnView childSn = map.getOrNull(child.getName());
                if (childSn == null) continue;
                this.matchImpl(child, childSn);
            }
        }
        if (item instanceof ConfigOpt) {
            ConfigOpt opt = (ConfigOpt)item;
            this.put(opt, view);
        }
    }

    public ValidatedConfig parseAndValidate() {
        ValidatedConfig validOptions = new ValidatedConfig();
        for (Map.Entry e : this.entrySet()) {
            Object valid;
            ConfigOpt opt = (ConfigOpt)e.getKey();
            SnView sn = (SnView)e.getValue();
            if (sn == null) continue;
            try {
                valid = this.parseAndValidateImpl(opt, sn, sn.ctx());
            }
            catch (ReportedException reported) {
                continue;
            }
            validOptions.put(opt, valid);
        }
        return validOptions;
    }

    private <T> T parseAndValidateImpl(ConfigOpt<T> opt, SnView view, CtxChain ctx) throws ReportedException {
        T parsed = opt.parse(view, ctx.detail("Option failed to parse"));
        T corrected = opt.correct(parsed, ctx.detail("Option needed correction"));
        opt.validate(corrected, ctx.detail("Option failed validation"));
        return corrected;
    }
}

