/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.quatlib.craftless.facet.facets;

import agency.highlysuspect.quatlib.craftless.facet.FacetBucket;
import agency.highlysuspect.quatlib.craftless.facet.Idable;
import agency.highlysuspect.quatlib.craftless.facet.facets.FacetBuilder;
import agency.highlysuspect.quatlib.craftless.facet.facets.LangFacet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class LangFacetBuilder
implements FacetBuilder {
    @NotNull
    final String file;
    String key;
    String value;

    public LangFacetBuilder(String file) {
        this.file = Objects.requireNonNull(file);
    }

    public LangFacetBuilder key(String key) {
        this.key = key;
        return this;
    }

    public LangFacetBuilder block(Idable id) {
        this.key = id.getId().toLangKey("block");
        return this;
    }

    public LangFacetBuilder item(Idable id) {
        this.key = id.getId().toLangKey("item");
        return this;
    }

    public LangFacetBuilder subtitle(Idable id) {
        this.key = id.getId().toSubtitleKey();
        return this;
    }

    public LangFacetBuilder value(String value) {
        this.value = value;
        return this;
    }

    public LangFacetBuilder block(Idable id, String value) {
        return this.block(id).value(value);
    }

    public LangFacetBuilder item(Idable id, String value) {
        return this.item(id).value(value);
    }

    public LangFacetBuilder subtitle(Idable id, String value) {
        return this.subtitle(id).value(value);
    }

    @Override
    public void build(FacetBuilder.BuildCtx ctx, FacetBucket facets) {
        if (ctx.dgen == null) {
            return;
        }
        Objects.requireNonNull(this.key, this::toString);
        Objects.requireNonNull(this.value, this::toString);
        facets.add(new LangFacet(this.file, this.key, this.value));
    }

    public String toString() {
        return "LangFacetBuilder(lang file '%s', key '%s', value '%s')".formatted(this.file, this.key, this.value);
    }
}

